/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.HashMap;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageProcessorRegistry;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LanguageProcessorRegistryTest {
    LanguageProcessorRegistryTest() {
    }

    @Test
    void loadEnvironmentVariables() throws Exception {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("PMD_DUMMY_ROOT_DIRECTORY", "theValue");
        Language dummyLanguage = DummyLanguageModule.getInstance().getDefaultVersion().getLanguage();
        LanguageRegistry languageRegistry = LanguageRegistry.singleton((Language)dummyLanguage);
        HashMap<Language, DummyLanguagePropertyBundle> languageProperties = new HashMap<Language, DummyLanguagePropertyBundle>();
        DummyLanguagePropertyBundle bundle = new DummyLanguagePropertyBundle(dummyLanguage);
        languageProperties.put(dummyLanguage, bundle);
        try (LanguageProcessorRegistry ignored = LanguageProcessorRegistry.create((LanguageRegistry)languageRegistry, languageProperties, (PmdReporter)PmdReporter.quiet(), env);){
            Assertions.assertEquals((Object)"theValue", (Object)bundle.getRootDirectory());
        }
    }

    private static class DummyLanguagePropertyBundle
    extends LanguagePropertyBundle {
        private static final PropertyDescriptor<String> ROOT_DIRECTORY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"rootDirectory").desc("Test")).defaultValue((Object)"")).build();

        DummyLanguagePropertyBundle(Language language) {
            super(language);
            this.definePropertyDescriptor(ROOT_DIRECTORY);
        }

        public String getRootDirectory() {
            return (String)this.getProperty(ROOT_DIRECTORY);
        }
    }
}

