/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.impl.SimpleLanguageModuleBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class LanguageModuleBaseTest {
    LanguageModuleBaseTest() {
    }

    @Test
    void testInvalidId() {
        LanguageModuleBaseTest.assertInvalidId("");
        LanguageModuleBaseTest.assertInvalidId("two words");
        LanguageModuleBaseTest.assertInvalidId("CapitalLetters");
        LanguageModuleBaseTest.assertInvalidId("C");
        LanguageModuleBaseTest.assertInvalidId("ab-c");
        Assertions.assertThrows(NullPointerException.class, () -> LanguageModuleBase.LanguageMetadata.withId(null));
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> LanguageModuleBase.LanguageMetadata.withId((String)"dummy").addVersion("", new String[0]), (String)"Empty versions should not be allowed.");
        Assertions.assertEquals((Object)"Invalid version name: ''", (Object)e.getMessage());
        Assertions.assertThrows(IllegalArgumentException.class, () -> LanguageModuleBase.LanguageMetadata.withId((String)"dummy").addVersion(" ", new String[0]), (String)"Empty versions should not be allowed.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LanguageModuleBase.LanguageMetadata.withId((String)"dummy").addVersion(null, new String[0]), (String)"Empty versions should not be allowed.");
        Assertions.assertThrows(IllegalArgumentException.class, () -> LanguageModuleBase.LanguageMetadata.withId((String)"dummy").addVersion("1.0", new String[]{""}), (String)"Empty versions should not be allowed.");
    }

    @Test
    void testVersions() {
        LanguageModuleBase lang = LanguageModuleBaseTest.makeLanguage(LanguageModuleBase.LanguageMetadata.withId((String)"dumdum").name("Name").extensions("o", new String[0]).addDefaultVersion("abc", new String[0]));
        MatcherAssert.assertThat((Object)lang.getDefaultVersion(), (Matcher)Matchers.equalTo((Object)lang.getVersion("abc")));
    }

    @Test
    void testMissingVersions() {
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> LanguageModuleBaseTest.makeLanguage(LanguageModuleBase.LanguageMetadata.withId((String)"dumdum").name("Name").extensions("o", new String[0])), (String)"Languages without versions should not be allowed.");
        Assertions.assertEquals((Object)"No versions for 'dumdum'", (Object)e.getMessage());
    }

    @Test
    void testNoExtensions() {
        Exception ex = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> LanguageModuleBaseTest.makeLanguage(LanguageModuleBase.LanguageMetadata.withId((String)"dumdum").name("Name").addVersion("abc", new String[0])));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)Matchers.containsString((String)"extension"));
    }

    @Test
    void testShortNameDefault() {
        LanguageModuleBase.LanguageMetadata meta = LanguageModuleBase.LanguageMetadata.withId((String)"java").name("Java");
        Assertions.assertEquals((Object)"Java", (Object)meta.getShortName());
    }

    @Test
    void testInvalidDependency() {
        LanguageModuleBase.LanguageMetadata meta = LanguageModuleBase.LanguageMetadata.withId((String)"java").name("Java");
        Assertions.assertThrows(IllegalArgumentException.class, () -> meta.dependsOnLanguage("not an id"));
    }

    private static LanguageModuleBase makeLanguage(LanguageModuleBase.LanguageMetadata meta) {
        return new SimpleLanguageModuleBase(meta, p -> {
            throw new UnsupportedOperationException("fake instance");
        });
    }

    private static void assertInvalidId(String id) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> LanguageModuleBase.LanguageMetadata.withId((String)id));
    }
}

