/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.io.IOException;
import java.util.Objects;
import net.sourceforge.pmd.cpd.AnyCpdLexer;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.cpd.CpdLanguageProperties;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.lang.AbstractPmdLanguageVersionHandler;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.impl.SimpleLanguageModuleBase;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathHandler;
import net.sourceforge.pmd.reporting.ViolationDecorator;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DummyLanguageModule
extends SimpleLanguageModuleBase
implements CpdCapableLanguage {
    public static final String NAME = "Dummy";
    public static final String TERSE_NAME = "dummy";
    private static final String PARSER_THROWS = "parserThrows";
    public static final String CPD_THROW_MALFORMED_SOURCE_EXCEPTION = ":throw_malformed_source_exception:";
    public static final String CPD_THROW_LEX_EXCEPTION = ":throw_lex_source_exception:";
    public static final String CPD_THROW_OTHER_EXCEPTION = ":throw_other_exception:";

    public DummyLanguageModule() {
        super(LanguageModuleBase.LanguageMetadata.withId((String)TERSE_NAME).name(NAME).extensions(TERSE_NAME, new String[]{"txt"}).addVersion("1.0", new String[0]).addVersion("1.1", new String[0]).addVersion("1.2", new String[0]).addVersion("1.3", new String[0]).addVersion("1.4", new String[0]).addVersion("1.5", new String[]{"5"}).addVersion("1.6", new String[]{"6"}).addDefaultVersion("1.7", new String[]{"7"}).addVersion(PARSER_THROWS, new String[0]).addVersion("1.8", new String[]{"8"}), (LanguageVersionHandler)new Handler());
    }

    public static DummyLanguageModule getInstance() {
        return (DummyLanguageModule)Objects.requireNonNull(LanguageRegistry.PMD.getLanguageByFullName(NAME));
    }

    public LanguagePropertyBundle newPropertyBundle() {
        LanguagePropertyBundle bundle = super.newPropertyBundle();
        bundle.definePropertyDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_LITERALS);
        bundle.definePropertyDescriptor(CpdLanguageProperties.CPD_ANONYMIZE_IDENTIFIERS);
        return bundle;
    }

    public CpdLexer createCpdLexer(LanguagePropertyBundle bundle) {
        AnyCpdLexer base = new AnyCpdLexer();
        return (arg_0, arg_1) -> DummyLanguageModule.lambda$createCpdLexer$0((CpdLexer)base, arg_0, arg_1);
    }

    public LanguageVersion getVersionWhereParserThrows() {
        return this.getVersion(PARSER_THROWS);
    }

    public static DummyNode.DummyRootNode readLispNode(Parser.ParserTask task) {
        TextDocument document = task.getTextDocument();
        DummyNode.DummyRootNode root = new DummyNode.DummyRootNode().withTaskInfo(task);
        root.setRegion(document.getEntireRegion());
        DummyNode top = root;
        int lastNodeStart = 0;
        Chars text = document.getText();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '(') {
                DummyNode node = text.startsWith("#text", i + 1) ? new DummyNode.DummyTextNode() : (text.startsWith("#comment", i + 1) ? new DummyNode.DummyCommentNode() : new DummyNode());
                node.setParent(top);
                top.addChild(node, top.getNumChildren());
                node.setRegion(TextRegion.caretAt((int)i));
                if (top.getImage() == null) {
                    String image = text.substring(lastNodeStart, i);
                    top.setImage(image);
                }
                lastNodeStart = i + 1;
                top = node;
                continue;
            }
            if (c != ')') continue;
            if (top == null) {
                throw new ParseException("Unbalanced parentheses: " + text);
            }
            top.setRegion(TextRegion.fromBothOffsets((int)top.getTextRegion().getStartOffset(), (int)(i + 1)));
            if (top.getImage() == null) {
                String image = text.substring(lastNodeStart, i);
                top.setImage(image);
                lastNodeStart = i + 1;
            }
            top = (DummyNode)top.getParent();
        }
        if (top != root) {
            throw new ParseException("Unbalanced parentheses: " + text);
        }
        return root;
    }

    public static @NonNull XPathFunctionDefinition imageIsFunction() {
        return new XPathFunctionDefinition("imageIs", (Language)DummyLanguageModule.getInstance()){

            public XPathFunctionDefinition.Type[] getArgumentTypes() {
                return new XPathFunctionDefinition.Type[]{XPathFunctionDefinition.Type.SINGLE_STRING};
            }

            public XPathFunctionDefinition.Type getResultType() {
                return XPathFunctionDefinition.Type.SINGLE_BOOLEAN;
            }

            public XPathFunctionDefinition.FunctionCall makeCallExpression() {
                return (contextNode, arguments) -> StringUtils.equals((CharSequence)arguments[0].toString(), (CharSequence)contextNode.getImage());
            }
        };
    }

    private static /* synthetic */ void lambda$createCpdLexer$0(CpdLexer base, TextDocument doc, TokenFactory tokens) throws IOException {
        Chars text = doc.getText();
        int offset = text.indexOf(CPD_THROW_LEX_EXCEPTION, 0);
        if (offset != -1) {
            TextPos2d lc = doc.lineColumnAtOffset(offset);
            throw tokens.makeLexException(lc.getLine(), lc.getColumn(), "test exception", null);
        }
        offset = text.indexOf(CPD_THROW_MALFORMED_SOURCE_EXCEPTION, 0);
        if (offset != -1) {
            FileLocation lc = doc.toLocation(TextRegion.caretAt((int)offset));
            throw new MalformedSourceException("test exception", null, lc);
        }
        offset = text.indexOf(CPD_THROW_OTHER_EXCEPTION, 0);
        if (offset != -1) {
            throw new IllegalArgumentException("test exception");
        }
        base.tokenize(doc, tokens);
    }

    public static class Handler
    extends AbstractPmdLanguageVersionHandler {
        public Parser getParser() {
            return task -> {
                if (task.getLanguageVersion().getVersion().equals(DummyLanguageModule.PARSER_THROWS)) {
                    throw new ParseException("ohio");
                }
                return DummyLanguageModule.readLispNode(task);
            };
        }

        public ViolationDecorator getViolationDecorator() {
            return (node, data) -> data.put("packageName", "foo");
        }

        public XPathHandler getXPathHandler() {
            return XPathHandler.getHandlerForFunctionDefs((XPathFunctionDefinition)DummyLanguageModule.imageIsFunction(), (XPathFunctionDefinition[])new XPathFunctionDefinition[0]);
        }

        public LanguageMetricsProvider getLanguageMetricsProvider() {
            return () -> CollectionUtil.setOf((Object)Metric.of((node, options) -> 1, node -> node, (String)"Constant value metric", (String[])new String[]{"const1"}), (Object[])new Metric[0]);
        }
    }
}

