/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.Objects;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageModuleBase;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.impl.BasePmdDialectLanguageVersionHandler;
import net.sourceforge.pmd.lang.impl.SimpleDialectLanguageModuleBase;
import net.sourceforge.pmd.lang.metrics.LanguageMetricsProvider;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathHandler;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DummyLanguageDialectModule
extends SimpleDialectLanguageModuleBase {
    public static final String NAME = "DummyDialect";
    public static final String TERSE_NAME = "dummydialect";
    public static final Metric<Node, Number> DUMMY_DIALECT_METRIC = Metric.of((node, options) -> null, node -> node, (String)"Constant NULL metric", (String[])new String[]{"null"});
    public static final PropertyDescriptor<Boolean> DUMMY_DIALECT_PROP = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"dummyDialectProperty").defaultValue((Object)false)).desc("Some dummy boolean without purpose")).build();

    public DummyLanguageDialectModule() {
        super(LanguageModuleBase.LanguageMetadata.withId((String)TERSE_NAME).name(NAME).extensions("txt", new String[]{"dummydlc"}).addDefaultVersion("1.0", new String[0]).asDialectOf("dummy"), (BasePmdDialectLanguageVersionHandler)new Handler());
    }

    public static DummyLanguageDialectModule getInstance() {
        return (DummyLanguageDialectModule)Objects.requireNonNull(LanguageRegistry.PMD.getLanguageByFullName(NAME));
    }

    protected @NonNull LanguagePropertyBundle newDialectPropertyBundle() {
        LanguagePropertyBundle bundle = super.newDialectPropertyBundle();
        bundle.definePropertyDescriptor(DUMMY_DIALECT_PROP);
        return bundle;
    }

    public static @NonNull XPathFunctionDefinition dummyDialectFunction() {
        return new XPathFunctionDefinition("dummyDialectFn", (Language)DummyLanguageDialectModule.getInstance()){

            public XPathFunctionDefinition.Type[] getArgumentTypes() {
                return new XPathFunctionDefinition.Type[]{XPathFunctionDefinition.Type.SINGLE_STRING};
            }

            public XPathFunctionDefinition.Type getResultType() {
                return XPathFunctionDefinition.Type.SINGLE_BOOLEAN;
            }

            public XPathFunctionDefinition.FunctionCall makeCallExpression() {
                return (contextNode, arguments) -> StringUtils.equals((CharSequence)arguments[0].toString(), (CharSequence)contextNode.getImage());
            }
        };
    }

    public static class Handler
    extends BasePmdDialectLanguageVersionHandler {
        public XPathHandler getXPathHandler() {
            return XPathHandler.getHandlerForFunctionDefs((XPathFunctionDefinition)DummyLanguageDialectModule.dummyDialectFunction(), (XPathFunctionDefinition[])new XPathFunctionDefinition[0]);
        }

        public LanguageMetricsProvider getLanguageMetricsProvider() {
            return () -> CollectionUtil.setOf(DUMMY_DIALECT_METRIC, (Object[])new Metric[0]);
        }
    }
}

