/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sourceforge.pmd.cpd.impl.BaseTokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BaseTokenFilterTest {
    BaseTokenFilterTest() {
    }

    @Test
    void testRemainingTokensFunctionality1() {
        StringTokenManager tokenManager = new StringTokenManager();
        DummyTokenFilter<StringToken> tokenFilter = new DummyTokenFilter<StringToken>(tokenManager);
        StringToken firstToken = (StringToken)tokenFilter.getNextToken();
        Assertions.assertEquals((Object)"a", (Object)firstToken.getImage());
        Iterable<StringToken> iterable = tokenFilter.getRemainingTokens();
        Iterator<StringToken> it1 = iterable.iterator();
        Iterator<StringToken> it2 = iterable.iterator();
        Assertions.assertTrue((boolean)it1.hasNext());
        Assertions.assertTrue((boolean)it2.hasNext());
        StringToken firstValFirstIt = it1.next();
        StringToken firstValSecondIt = it2.next();
        Assertions.assertTrue((boolean)it1.hasNext());
        Assertions.assertTrue((boolean)it2.hasNext());
        StringToken secondValFirstIt = it1.next();
        Assertions.assertFalse((boolean)it1.hasNext());
        Assertions.assertTrue((boolean)it2.hasNext());
        StringToken secondValSecondIt = it2.next();
        Assertions.assertFalse((boolean)it2.hasNext());
        Assertions.assertEquals((Object)"b", (Object)firstValFirstIt.getImage());
        Assertions.assertEquals((Object)"b", (Object)firstValSecondIt.getImage());
        Assertions.assertEquals((Object)"c", (Object)secondValFirstIt.getImage());
        Assertions.assertEquals((Object)"c", (Object)secondValSecondIt.getImage());
    }

    @Test
    void testRemainingTokensFunctionality2() {
        StringTokenManager tokenManager = new StringTokenManager();
        DummyTokenFilter<StringToken> tokenFilter = new DummyTokenFilter<StringToken>(tokenManager);
        StringToken firstToken = (StringToken)tokenFilter.getNextToken();
        Assertions.assertEquals((Object)"a", (Object)firstToken.getImage());
        Iterable<StringToken> iterable = tokenFilter.getRemainingTokens();
        Iterator<StringToken> it1 = iterable.iterator();
        Iterator<StringToken> it2 = iterable.iterator();
        Assertions.assertTrue((boolean)it1.hasNext());
        Assertions.assertTrue((boolean)it2.hasNext());
        StringToken firstValFirstIt = it1.next();
        Assertions.assertTrue((boolean)it1.hasNext());
        StringToken secondValFirstIt = it1.next();
        Assertions.assertFalse((boolean)it1.hasNext());
        Assertions.assertTrue((boolean)it2.hasNext());
        StringToken firstValSecondIt = it2.next();
        Assertions.assertTrue((boolean)it2.hasNext());
        StringToken secondValSecondIt = it2.next();
        Assertions.assertFalse((boolean)it2.hasNext());
        Assertions.assertEquals((Object)"b", (Object)firstValFirstIt.getImage());
        Assertions.assertEquals((Object)"b", (Object)firstValSecondIt.getImage());
        Assertions.assertEquals((Object)"c", (Object)secondValFirstIt.getImage());
        Assertions.assertEquals((Object)"c", (Object)secondValSecondIt.getImage());
    }

    @Test
    void testRemainingTokensFunctionality3() {
        StringTokenManager tokenManager = new StringTokenManager();
        DummyTokenFilter<StringToken> tokenFilter = new DummyTokenFilter<StringToken>(tokenManager);
        StringToken firstToken = (StringToken)tokenFilter.getNextToken();
        Assertions.assertEquals((Object)"a", (Object)firstToken.getImage());
        Iterable<StringToken> iterable = tokenFilter.getRemainingTokens();
        Iterator<StringToken> it1 = iterable.iterator();
        Iterator<StringToken> it2 = iterable.iterator();
        it1.next();
        it1.next();
        it2.next();
        it2.next();
        Assertions.assertThrows(NoSuchElementException.class, () -> it1.next());
    }

    @Test
    void testRemainingTokensFunctionality4() {
        StringTokenManager tokenManager = new StringTokenManager();
        DummyTokenFilter<StringToken> tokenFilter = new DummyTokenFilter<StringToken>(tokenManager);
        StringToken firstToken = (StringToken)tokenFilter.getNextToken();
        Assertions.assertEquals((Object)"a", (Object)firstToken.getImage());
        Iterable<StringToken> iterable = tokenFilter.getRemainingTokens();
        Iterator<StringToken> it1 = iterable.iterator();
        StringToken secondToken = (StringToken)tokenFilter.getNextToken();
        Assertions.assertEquals((Object)"b", (Object)secondToken.getImage());
        Assertions.assertThrows(ConcurrentModificationException.class, () -> it1.next());
    }

    static class DummyTokenFilter<T extends GenericToken<T>>
    extends BaseTokenFilter<T> {
        Iterable<T> remainingTokens;

        DummyTokenFilter(TokenManager<T> tokenManager) {
            super(tokenManager);
        }

        protected boolean shouldStopProcessing(T currentToken) {
            return currentToken == null;
        }

        protected void analyzeTokens(T currentToken, Iterable<T> remainingTokens) {
            this.remainingTokens = remainingTokens;
        }

        public Iterable<T> getRemainingTokens() {
            return this.remainingTokens;
        }
    }

    static class StringTokenManager
    implements TokenManager<StringToken> {
        Iterator<String> iterator = Collections.unmodifiableList(Arrays.asList("a", "b", "c")).iterator();

        StringTokenManager() {
        }

        public StringToken getNextToken() {
            if (this.iterator.hasNext()) {
                return new StringToken(this.iterator.next());
            }
            return null;
        }
    }

    static class StringToken
    implements GenericToken<StringToken> {
        private final String text;

        StringToken(String text) {
            this.text = text;
        }

        public StringToken getNext() {
            return null;
        }

        public StringToken getPreviousComment() {
            return null;
        }

        public TextRegion getRegion() {
            return TextRegion.fromBothOffsets((int)0, (int)this.text.length());
        }

        public boolean isEof() {
            return this.text == null;
        }

        public String getImageCs() {
            return this.text;
        }

        public FileLocation getReportLocation() {
            return FileLocation.range((FileId)FileId.UNKNOWN, (TextRange2d)TextRange2d.range2d((int)1, (int)1, (int)1, (int)1));
        }

        public int compareTo(StringToken o) {
            return this.text.compareTo(o.text);
        }

        public int getKind() {
            return 0;
        }
    }
}

