/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.pmd.cpd.CpdTestUtils;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.XMLOldRenderer;
import net.sourceforge.pmd.lang.document.FileId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class XMLOldRendererTest {
    private static final String ENCODING = (String)System.getProperties().get("file.encoding");

    XMLOldRendererTest() {
    }

    @Test
    void testWithNoDuplication() throws IOException, ParserConfigurationException, SAXException {
        XMLOldRenderer renderer = new XMLOldRenderer();
        StringWriter sw = new StringWriter();
        renderer.render(CpdTestUtils.makeReport(Collections.emptyList()), (Writer)sw);
        String report = sw.toString();
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<pmd-cpd/>\n", (Object)report, (String)"no namespace expected");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes(ENCODING)));
        NodeList nodes = doc.getChildNodes();
        Node n = nodes.item(0);
        Assertions.assertEquals((Object)"pmd-cpd", (Object)n.getNodeName());
        Assertions.assertEquals((int)0, (int)doc.getElementsByTagName("duplication").getLength());
    }

    @Test
    void testWithOneDuplication() throws Exception {
        Node file;
        XMLOldRenderer renderer = new XMLOldRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        int lineCount = 6;
        FileId foo1 = CpdTestUtils.FOO_FILE_ID;
        Mark mark1 = builder.createMark("public", foo1, 1, lineCount);
        Mark mark2 = builder.createMark("stuff", foo1, 73, lineCount);
        builder.addMatch(new Match(75, mark1, mark2));
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(report.getBytes(ENCODING)));
        NodeList dupes = doc.getElementsByTagName("duplication");
        Assertions.assertEquals((int)1, (int)dupes.getLength());
        for (file = dupes.item(0).getFirstChild(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
        }
        if (file != null) {
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assertions.assertEquals((Object)foo1.getAbsolutePath(), (Object)file.getAttributes().getNamedItem("path").getNodeValue());
            Assertions.assertEquals((Object)"6", (Object)file.getAttributes().getNamedItem("endline").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("column").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("endcolumn").getNodeValue());
            for (file = file.getNextSibling(); file != null && file.getNodeType() != 1; file = file.getNextSibling()) {
            }
        }
        if (file != null) {
            Assertions.assertEquals((Object)"73", (Object)file.getAttributes().getNamedItem("line").getNodeValue());
            Assertions.assertEquals((Object)"78", (Object)file.getAttributes().getNamedItem("endline").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("column").getNodeValue());
            Assertions.assertEquals((Object)"1", (Object)file.getAttributes().getNamedItem("endcolumn").getNodeValue());
        }
        Assertions.assertEquals((int)1, (int)doc.getElementsByTagName("codefragment").getLength());
        Assertions.assertEquals((Object)CpdTestUtils.generateDummyContent(lineCount), (Object)doc.getElementsByTagName("codefragment").item(0).getTextContent());
    }
}

