/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Iterator;
import net.sourceforge.pmd.cpd.CpdTestUtils;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MatchTest {
    MatchTest() {
    }

    @Test
    void testSimple() {
        String codeFragment1 = "1234567890";
        FileId fileName = CpdTestUtils.FOO_FILE_ID;
        TextFile tf = TextFile.forCharSeq((CharSequence)codeFragment1, (FileId)fileName, (LanguageVersion)DummyLanguageModule.getInstance().getDefaultVersion());
        SourceManager sourceManager = new SourceManager(CollectionUtil.listOf((Object)tf, (Object[])new TextFile[0]));
        Tokens tokens = new Tokens();
        Mark mark1 = new Mark(tokens.addToken("public", fileName, 1, 1, 1, 1 + "public".length()));
        Mark mark2 = new Mark(tokens.addToken("public", fileName, 1, 1, 1, 1 + "public".length()));
        Match match = new Match(1, mark1, mark2);
        Assertions.assertEquals((int)1, (int)match.getTokenCount());
        Assertions.assertEquals((int)1, (int)match.getLineCount());
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"1234567890"), (Object)sourceManager.getSlice(match.getFirstMark()));
        Iterator i = match.iterator();
        Mark occurrence1 = (Mark)i.next();
        Mark occurrence2 = (Mark)i.next();
        Assertions.assertFalse((boolean)i.hasNext());
        Assertions.assertEquals((Object)mark1, (Object)occurrence1);
        Assertions.assertEquals((int)1, (int)occurrence1.getLocation().getLineCount());
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"1234567890"), (Object)sourceManager.getSlice(mark1));
        Assertions.assertEquals((Object)mark2, (Object)occurrence2);
        Assertions.assertEquals((int)1, (int)occurrence2.getLocation().getLineCount());
        Assertions.assertEquals((Object)Chars.wrap((CharSequence)"1234567890"), (Object)sourceManager.getSlice(mark2));
    }

    @Test
    void testCompareTo() {
        Tokens tokens = new Tokens();
        FileId fileName = CpdTestUtils.FOO_FILE_ID;
        Match m1 = new Match(1, tokens.addToken("public", fileName, 1, 2, 3, 4), tokens.addToken("class", fileName, 1, 2, 3, 4));
        Match m2 = new Match(2, tokens.addToken("Foo", fileName, 1, 2, 3, 4), tokens.addToken("{", fileName, 1, 2, 3, 4));
        Assertions.assertTrue((m2.compareTo(m1) < 0 ? 1 : 0) != 0);
    }
}

