/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.CpdTestUtils;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class MarkTest {
    MarkTest() {
    }

    @Test
    void testSimple() {
        FileId filename = CpdTestUtils.FOO_FILE_ID;
        Tokens tokens = new Tokens();
        TokenEntry token = tokens.addToken("public", filename, 1, 2, 3, 4);
        Mark mark = new Mark(token);
        FileLocation loc = mark.getLocation();
        Assertions.assertEquals((Object)token, (Object)mark.getToken());
        Assertions.assertEquals((Object)filename, (Object)loc.getFileId());
        Assertions.assertEquals((int)1, (int)loc.getStartLine());
        Assertions.assertEquals((int)3, (int)loc.getLineCount());
        Assertions.assertEquals((int)3, (int)loc.getEndLine());
        Assertions.assertEquals((int)2, (int)loc.getStartColumn());
        Assertions.assertEquals((int)4, (int)loc.getEndColumn());
    }

    @Test
    void testColumns() {
        FileId filename = CpdTestUtils.FOO_FILE_ID;
        Tokens tokens = new Tokens();
        boolean beginLine = true;
        int beginColumn = 2;
        int endColumn = 2;
        int lineCount = 10;
        TokenEntry token = tokens.addToken("public", filename, 1, 2, 1, 2 + "public".length());
        TokenEntry endToken = tokens.addToken("}", filename, 11, 1, 10, 2);
        Mark mark = new Mark(token);
        mark.setEndToken(endToken);
        FileLocation loc = mark.getLocation();
        Assertions.assertEquals((Object)token, (Object)mark.getToken());
        Assertions.assertEquals((Object)filename, (Object)loc.getFileId());
        Assertions.assertEquals((int)1, (int)loc.getStartLine());
        Assertions.assertEquals((int)10, (int)loc.getLineCount());
        Assertions.assertEquals((int)10, (int)loc.getEndLine());
        Assertions.assertEquals((int)2, (int)loc.getStartColumn());
        Assertions.assertEquals((int)2, (int)loc.getEndColumn());
    }
}

