/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sourceforge.pmd.internal.util.IOUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CpdXsltTest {
    CpdXsltTest() {
    }

    @Test
    void cpdhtml() throws Exception {
        String result = this.runXslt("cpdhtml.xslt");
        String expected = IOUtil.readToString((InputStream)CpdXsltTest.class.getResourceAsStream("ExpectedCpdHtmlReport.html"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    @Test
    void cpdhtmlv2() throws Exception {
        String result = this.runXslt("cpdhtml-v2.xslt");
        String expected = IOUtil.readToString((InputStream)CpdXsltTest.class.getResourceAsStream("ExpectedCpdHtmlReport-v2.html"), (Charset)StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)expected, (Object)result);
    }

    private String runXslt(String stylesheet) throws Exception {
        XSLTErrorListener errorListener = new XSLTErrorListener();
        TransformerFactory factory = TransformerFactory.newInstance("com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl", null);
        factory.setErrorListener(errorListener);
        StreamSource xslt = new StreamSource(new File("etc/xslt/" + stylesheet));
        Templates template = factory.newTemplates(xslt);
        StreamSource cpdReport = new StreamSource(CpdXsltTest.class.getResourceAsStream("SampleCpdReport.xml"));
        StreamResult result = new StreamResult(new StringWriter());
        Transformer transformer = template.newTransformer();
        transformer.setErrorListener(errorListener);
        transformer.transform(cpdReport, result);
        Assertions.assertTrue((boolean)errorListener.hasNoErrors(), (String)("XSLT errors occured: " + errorListener));
        return result.getWriter().toString();
    }

    private static class XSLTErrorListener
    implements ErrorListener {
        final List<TransformerException> errors = new ArrayList<TransformerException>();

        private XSLTErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            this.errors.add(exception);
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            this.errors.add(exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            this.errors.add(exception);
        }

        public boolean hasNoErrors() {
            return this.errors.isEmpty();
        }

        public String toString() {
            return this.errors.toString();
        }
    }
}

