/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.CpdTestUtils;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.lang.document.FileId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CSVRendererTest {
    CSVRendererTest() {
    }

    @Test
    void testLineCountPerFile() throws IOException {
        CSVRenderer renderer = new CSVRenderer(true);
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        Mark mark1 = builder.createMark("public", CpdTestUtils.FOO_FILE_ID, 48, 10);
        Mark mark2 = builder.createMark("stuff", CpdTestUtils.BAR_FILE_ID, 73, 20);
        builder.addMatch(new Match(75, mark1, mark2));
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        String expectedReport = "tokens,occurrences" + System.lineSeparator() + "75,2,48,10," + CpdTestUtils.FOO_FILE_ID.getAbsolutePath() + ",73,20," + CpdTestUtils.BAR_FILE_ID.getAbsolutePath() + System.lineSeparator();
        Assertions.assertEquals((Object)expectedReport, (Object)report);
    }

    @Test
    void testFilenameEscapes() throws IOException {
        CSVRenderer renderer = new CSVRenderer();
        CpdTestUtils.CpdReportBuilder builder = new CpdTestUtils.CpdReportBuilder();
        FileId foo = FileId.fromPathLikeString((String)"/var,with,commas/Foo.java");
        FileId bar = FileId.fromPathLikeString((String)"/var,with,commas/Bar.java");
        Mark mark1 = builder.createMark("public", foo, 48, 10);
        Mark mark2 = builder.createMark("stuff", bar, 73, 20);
        builder.addMatch(new Match(75, mark1, mark2));
        StringWriter sw = new StringWriter();
        renderer.render(builder.build(), (Writer)sw);
        String report = sw.toString();
        String expectedReport = "lines,tokens,occurrences" + System.lineSeparator() + "10,75,2,48,\"" + foo.getAbsolutePath() + "\",73,\"" + bar.getAbsolutePath() + "\"" + System.lineSeparator();
        Assertions.assertEquals((Object)expectedReport, (Object)report);
    }
}

