/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.cpd.AnyCpdLexer;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class AnyCpdLexerTest {
    private static final List<String> EXPECTED = CollectionUtil.listOf((Object)"using", (Object[])new String[]{"System", ";", "namespace", "HelloNameSpace", "{", "public", "class", "HelloWorld", "{", "static", "void", "Main", "(", "string", "[", "]", "args", ")", "{", "Console", ".", "WriteLine", "(", "\"Hello World!\"", ")", ";", "}", "}", "}", "EOF"});
    private static final String TEST1 = "using System;\nnamespace HelloNameSpace {\n\n    public class HelloWorld { // A comment\n        static void Main(string[] args) {\n\n            Console.WriteLine(\"Hello World!\");\n        }\n    }\n\n}\n";

    AnyCpdLexerTest() {
    }

    @Test
    void testMultiLineMacros() throws IOException {
        AnyCpdLexer tokenizer = new AnyCpdLexer("//");
        this.compareResult(tokenizer, TEST1, EXPECTED);
    }

    @Test
    void testStringEscape() throws IOException {
        AnyCpdLexer tokenizer = new AnyCpdLexer("//");
        this.compareResult(tokenizer, "a = \"oo\\n\"", CollectionUtil.listOf((Object)"a", (Object[])new String[]{"=", "\"oo\\n\"", "EOF"}));
    }

    @Test
    void testMultilineString() throws IOException {
        AnyCpdLexer tokenizer = new AnyCpdLexer("//");
        Tokens tokens = this.compareResult(tokenizer, "a = \"oo\n\";", CollectionUtil.listOf((Object)"a", (Object[])new String[]{"=", "\"oo\n\"", ";", "EOF"}));
        TokenEntry string = (TokenEntry)tokens.getTokens().get(2);
        Assertions.assertEquals((Object)"\"oo\n\"", (Object)string.getImage(tokens));
        Assertions.assertEquals((int)1, (int)string.getBeginLine());
        Assertions.assertEquals((int)5, (int)string.getBeginColumn());
        Assertions.assertEquals((int)2, (int)string.getEndColumn());
        TokenEntry semi = (TokenEntry)tokens.getTokens().get(3);
        Assertions.assertEquals((Object)";", (Object)semi.getImage(tokens));
        Assertions.assertEquals((int)2, (int)semi.getBeginLine());
        Assertions.assertEquals((int)2, (int)semi.getBeginColumn());
        Assertions.assertEquals((int)3, (int)semi.getEndColumn());
    }

    @Test
    void testTokenPosition() throws IOException {
        AnyCpdLexer tokenizer = new AnyCpdLexer();
        TextDocument code = TextDocument.readOnlyString((CharSequence)"a;\nbbbb\n;", (FileId)FileId.UNKNOWN, (LanguageVersion)DummyLanguageModule.getInstance().getDefaultVersion());
        Tokens tokens = new Tokens();
        CpdLexer.tokenize((CpdLexer)tokenizer, (TextDocument)code, (Tokens)tokens);
        TokenEntry bbbbToken = (TokenEntry)tokens.getTokens().get(2);
        Assertions.assertEquals((int)2, (int)bbbbToken.getBeginLine());
        Assertions.assertEquals((int)1, (int)bbbbToken.getBeginColumn());
        Assertions.assertEquals((int)5, (int)bbbbToken.getEndColumn());
    }

    private Tokens compareResult(AnyCpdLexer tokenizer, String source, List<String> expectedImages) throws IOException {
        TextDocument code = TextDocument.readOnlyString((CharSequence)source, (FileId)FileId.UNKNOWN, (LanguageVersion)DummyLanguageModule.getInstance().getDefaultVersion());
        Tokens tokens = new Tokens();
        CpdLexer.tokenize((CpdLexer)tokenizer, (TextDocument)code, (Tokens)tokens);
        ArrayList<String> tokenStrings = new ArrayList<String>();
        for (TokenEntry token : tokens.getTokens()) {
            tokenStrings.add(token.getImage(tokens));
        }
        Assertions.assertEquals(expectedImages, tokenStrings);
        return tokens;
    }
}

