/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cache.internal;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.sourceforge.pmd.cache.internal.AbstractClasspathEntryFingerprinterTest;
import net.sourceforge.pmd.cache.internal.ClasspathEntryFingerprinter;
import net.sourceforge.pmd.cache.internal.ZipFileFingerprinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ZipFileFingerprinterTest
extends AbstractClasspathEntryFingerprinterTest {
    ZipFileFingerprinterTest() {
    }

    @Test
    void zipEntryMetadataDoesNotAffectFingerprint() throws IOException {
        File file = this.createValidNonEmptyFile();
        long baselineFingerprint = this.getBaseLineFingerprint(file);
        long originalFileSize = file.length();
        try (ZipFile zip = new ZipFile(file);){
            ZipEntry zipEntry = zip.entries().nextElement();
            zipEntry.setComment("some comment");
            zipEntry.setTime(System.currentTimeMillis() + 1000L);
            this.overwriteZipFileContents(file, zipEntry);
        }
        Assertions.assertEquals((long)baselineFingerprint, (long)this.updateFingerprint(file));
        Assertions.assertNotEquals((long)originalFileSize, (long)file.length());
    }

    @Test
    void zipEntryOrderDoesNotAffectFingerprint() throws IOException {
        File zipFile = this.tempDir.resolve("foo.jar").toFile();
        ZipEntry fooEntry = new ZipEntry("lib/Foo.class");
        ZipEntry barEntry = new ZipEntry("lib/Bar.class");
        this.overwriteZipFileContents(zipFile, fooEntry, barEntry);
        long baselineFingerprint = this.getBaseLineFingerprint(zipFile);
        this.overwriteZipFileContents(zipFile, barEntry, fooEntry);
        Assertions.assertEquals((long)baselineFingerprint, (long)this.updateFingerprint(zipFile));
    }

    @Test
    void nonClassZipEntryDoesNotAffectFingerprint() throws IOException {
        File zipFile = this.tempDir.resolve("foo.jar").toFile();
        ZipEntry fooEntry = new ZipEntry("lib/Foo.class");
        ZipEntry barEntry = new ZipEntry("bar.properties");
        this.overwriteZipFileContents(zipFile, fooEntry);
        long baselineFingerprint = this.getBaseLineFingerprint(zipFile);
        this.overwriteZipFileContents(zipFile, fooEntry, barEntry);
        Assertions.assertEquals((long)baselineFingerprint, (long)this.updateFingerprint(zipFile));
    }

    @Override
    protected ClasspathEntryFingerprinter newFingerPrinter() {
        return new ZipFileFingerprinter();
    }

    @Override
    protected String[] getValidFileExtensions() {
        return new String[]{"zip", "jar"};
    }

    @Override
    protected String[] getInvalidFileExtensions() {
        return new String[]{"xml"};
    }

    @Override
    protected File createValidNonEmptyFile() throws IOException {
        File zipFile = this.tempDir.resolve("foo.jar").toFile();
        this.overwriteZipFileContents(zipFile, new ZipEntry("lib/Foo.class"));
        return zipFile;
    }

    private void overwriteZipFileContents(File zipFile, ZipEntry ... zipEntries) throws IOException {
        try (ZipOutputStream zipOS = new ZipOutputStream(Files.newOutputStream(zipFile.toPath(), new OpenOption[0]));){
            for (ZipEntry zipEntry : zipEntries) {
                zipOS.putNextEntry(zipEntry);
                zipOS.write("content of zip entry".getBytes(StandardCharsets.UTF_8));
                zipOS.closeEntry();
            }
        }
    }

    private long getBaseLineFingerprint(File file) throws MalformedURLException, IOException {
        Adler32 checksum = new Adler32();
        this.fingerprinter.fingerprint(file.toURI().toURL(), (Checksum)checksum);
        return checksum.getValue();
    }
}

