/*
 * BSD-style license; for more info see http://pmd.sourceforge.net/license.html
 */

package net.sourceforge.pmd.lang.ast.impl.antlr4;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Lexer;

import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.Parser;
import net.sourceforge.pmd.lang.ast.RootNode;

/**
 * Generic Antlr parser adapter for all Antlr parsers. This wraps a parser
 * generated by antlr, soo {@link AntlrGeneratedParserBase}.
 *
 * @param <N> Supertype of all nodes for the language, eg SwiftNode
 * @param <R> Type of the root node
 */
public abstract class AntlrBaseParser<
    N extends AntlrNode<N>,
    R extends BaseAntlrInnerNode<N> & RootNode
    > implements Parser {

    @Override
    public R parse(ParserTask task) throws ParseException {
        CharStream cs = CharStreams.fromString(task.getSourceText(), task.getTextDocument().getFileId().getAbsolutePath());
        return parse(getLexer(cs), task);
    }

    protected abstract R parse(Lexer parser, ParserTask task);

    protected abstract Lexer getLexer(CharStream source);
}
