/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.Objects;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionException;

public final class FileNameXPathFunction
extends XPathFunctionDefinition {
    public static final FileNameXPathFunction INSTANCE = new FileNameXPathFunction();

    private FileNameXPathFunction() {
        super("fileName");
    }

    @Override
    public XPathFunctionDefinition.Type getResultType() {
        return XPathFunctionDefinition.Type.SINGLE_STRING;
    }

    @Override
    public boolean dependsOnContext() {
        return true;
    }

    @Override
    public XPathFunctionDefinition.FunctionCall makeCallExpression() {
        return (node, arguments) -> {
            if (node == null) {
                throw new XPathFunctionException("Cannot call function '" + this.getQName().getLocalPart() + "' without context item");
            }
            RootNode root = node.getRoot();
            Objects.requireNonNull(root, "No root node in tree?");
            String fileName = root.getTextDocument().getFileId().getFileName();
            Objects.requireNonNull(fileName, "File name was not set");
            return fileName;
        };
    }
}

