/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.sourceforge.pmd.lang.LanguageProcessor;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.AbstractRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RuleTargetSelector;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.PmdXPathException;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.lang.rule.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonXPathRuleQuery;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.IteratorUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XPathRule
extends AbstractRule {
    private static final Logger LOG = LoggerFactory.getLogger(XPathRule.class);
    private static final PropertyDescriptor<String> XPATH_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty("xpath").desc("XPath expression")).defaultValue("")).build();
    private SaxonXPathRuleQuery xpathRuleQuery;
    private DeprecatedAttrLogger attrLogger = DeprecatedAttrLogger.create(this);

    XPathRule() {
        this.definePropertyDescriptor(XPATH_DESCRIPTOR);
    }

    public XPathRule(XPathVersion version, String expression) {
        this();
        Objects.requireNonNull(version, "XPath version is null");
        Objects.requireNonNull(expression, "XPath expression is null");
        this.setProperty(XPATH_DESCRIPTOR, expression);
    }

    @Override
    public Rule deepCopy() {
        XPathRule rule = (XPathRule)super.deepCopy();
        rule.attrLogger = this.attrLogger;
        return rule;
    }

    public String getXPathExpression() {
        return this.getProperty(XPATH_DESCRIPTOR);
    }

    @Override
    public void apply(Node target, RuleContext ctx) {
        List<Node> nodesWithViolation;
        SaxonXPathRuleQuery query = this.getQueryMaybeInitialize();
        try {
            nodesWithViolation = query.evaluate(target);
        }
        catch (PmdXPathException e) {
            throw this.addExceptionContext(e);
        }
        for (Node nodeWithViolation : nodesWithViolation) {
            String messageArg = nodeWithViolation.getImage();
            if (messageArg == null) {
                messageArg = this.getFirstMessageArgFromNode(nodeWithViolation, "Name", "SimpleName", "MethodName");
            }
            ctx.addViolation(nodeWithViolation, messageArg);
        }
    }

    private String getFirstMessageArgFromNode(Node node, String ... attributeNames) {
        List<String> nameList = Arrays.asList(attributeNames);
        return IteratorUtil.toStream(node.getXPathAttributesIterator()).filter(a -> nameList.contains(a.getName())).findFirst().map(Attribute::getStringValue).orElse(null);
    }

    private ContextedRuntimeException addExceptionContext(PmdXPathException e) {
        return e.addRuleName(this.getName());
    }

    @Override
    public void initialize(LanguageProcessor languageProcessor) {
        String xpath = this.getXPathExpression();
        XPathVersion version = XPathVersion.DEFAULT;
        try {
            this.xpathRuleQuery = new SaxonXPathRuleQuery(xpath, version, this.getPropertiesByPropertyDescriptor(), languageProcessor.services().getXPathHandler(), this.attrLogger);
        }
        catch (PmdXPathException e) {
            throw this.addExceptionContext(e);
        }
    }

    private SaxonXPathRuleQuery getQueryMaybeInitialize() throws PmdXPathException {
        if (this.xpathRuleQuery == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.xpathRuleQuery;
    }

    @Override
    protected @NonNull RuleTargetSelector buildTargetSelector() {
        List<String> visits = this.getQueryMaybeInitialize().getRuleChainVisits();
        this.logXPathRuleChainUsage(!visits.isEmpty());
        return visits.isEmpty() ? RuleTargetSelector.forRootOnly() : RuleTargetSelector.forXPathNames(visits);
    }

    private void logXPathRuleChainUsage(boolean usesRuleChain) {
        LOG.debug("{} rule chain for XPath rule: {} ({})", new Object[]{usesRuleChain ? "Using" : "no", this.getName(), this.getRuleSetName()});
    }

    @Override
    public String dysfunctionReason() {
        if (StringUtils.isBlank((CharSequence)this.getXPathExpression())) {
            return "Missing XPath expression";
        }
        return null;
    }
}

