/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

public enum RulePriority {
    HIGH(1, "High"),
    MEDIUM_HIGH(2, "Medium High"),
    MEDIUM(3, "Medium"),
    MEDIUM_LOW(4, "Medium Low"),
    LOW(5, "Low");

    private final int priority;
    private final String name;

    private RulePriority(int priority, String name) {
        this.priority = priority;
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static RulePriority valueOf(int priority) {
        try {
            return RulePriority.values()[priority - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return LOW;
        }
    }

    public static RulePriority valueOfNullable(int priority) {
        try {
            return RulePriority.values()[priority - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public static RulePriority valueOfNullable(String priority) {
        try {
            int integer = Integer.parseInt(priority);
            return RulePriority.values()[integer - 1];
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }
}

