/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LanguageMetricsProvider {
    public Set<Metric<?, ?>> getMetrics();

    default public @Nullable Metric<?, ?> getMetricWithName(String nameIgnoringCase) {
        for (Metric<?, ?> metric : this.getMetrics()) {
            for (String nameAlias : metric.nameAliases()) {
                if (!nameAlias.equalsIgnoreCase(nameIgnoringCase)) continue;
                return metric;
            }
        }
        return null;
    }

    default public Map<Metric<?, ?>, Number> computeAllMetricsFor(Node node) {
        HashMap results = new HashMap();
        for (Metric<?, ?> metric : this.getMetrics()) {
            @Nullable ? result = Metric.compute(metric, node, MetricOptions.emptyOptions());
            if (result == null) continue;
            results.put(metric, (Number)result);
        }
        return results;
    }
}

