/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.util.Arrays;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.util.AssertionUtil;

final class SourceCodePositioner {
    private final int[] lineOffsets;
    private final int sourceCodeLength;

    private SourceCodePositioner(int[] offsets, int len) {
        this.lineOffsets = offsets;
        this.sourceCodeLength = len;
    }

    int[] getLineOffsets() {
        return this.lineOffsets;
    }

    TextPos2d lineColFromOffset(int offset, boolean inclusive) {
        AssertionUtil.requireInInclusiveRange("offset", offset, 0, this.sourceCodeLength);
        int line = this.searchLineOffset(offset);
        int lineIdx = line - 1;
        if (lineIdx != 0 && offset == this.lineOffsets[lineIdx] && !inclusive) {
            return TextPos2d.pos2d(lineIdx, this.getLastColumnOfLine(lineIdx));
        }
        return TextPos2d.pos2d(line, 1 + offset - this.lineOffsets[lineIdx]);
    }

    public int lineNumberFromOffset(int offset) {
        AssertionUtil.requireIndexNonNegative("offset", offset);
        if (offset > this.sourceCodeLength) {
            return -1;
        }
        return this.searchLineOffset(offset);
    }

    private int searchLineOffset(int offset) {
        int search = Arrays.binarySearch(this.lineOffsets, 0, this.lineOffsets.length - 1, offset);
        return search >= 0 ? search + 1 : ~search;
    }

    public int columnFromOffset(int lineNumber, int globalOffset) {
        AssertionUtil.requireInPositiveRange("Line number", lineNumber, this.lineOffsets.length);
        int lineIndex = lineNumber - 1;
        if (globalOffset > this.lineOffsets[lineNumber]) {
            return -1;
        }
        return globalOffset - this.lineOffsets[lineIndex] + 1;
    }

    public int offsetFromLineColumn(int line, int column) {
        if (!this.isValidLine(line)) {
            if (line == this.lineOffsets.length && column == 1) {
                return this.sourceCodeLength;
            }
            return -1;
        }
        int lineIdx = line - 1;
        int off = this.lineOffsets[lineIdx] + column - 1;
        int bound = this.offsetOfEndOfLine(line);
        return off > bound ? -1 : off;
    }

    public int offsetOfEndOfLine(int line) {
        if (!this.isValidLine(line)) {
            throw new IndexOutOfBoundsException(line + " is not a valid line number, expected at most " + this.lineOffsets.length);
        }
        return this.lineOffsets[line];
    }

    boolean isValidLine(int line) {
        return line >= 1 && line <= this.getLastLine();
    }

    public int getLastLine() {
        return this.lineOffsets.length - 1;
    }

    public int getNumLines() {
        return this.getLastLine();
    }

    public int getLastLineColumn() {
        return this.getLastColumnOfLine(this.getLastLine());
    }

    private int getLastColumnOfLine(int line) {
        if (line == 0) {
            return 1 + this.lineOffsets[line];
        }
        return 1 + this.lineOffsets[line] - this.lineOffsets[line - 1];
    }

    public static SourceCodePositioner create(CharSequence charSeq) {
        int len = charSeq.length();
        Builder builder = new Builder();
        for (int off = 0; off < len; ++off) {
            char c = charSeq.charAt(off);
            if (c != '\n') continue;
            builder.addLineEndAtOffset(off + 1);
        }
        return builder.build(len);
    }

    static final class Builder {
        private int[] buf;
        private int count = 1;
        private int lastLineOffset = 0;

        Builder(int bufSize) {
            this.buf = new int[Math.max(1, bufSize)];
        }

        Builder() {
            this(400);
        }

        public void addLineEndAtOffset(int offset) {
            this.addLineImpl(offset, false);
        }

        private void addLineImpl(int offset, boolean isEof) {
            if (offset < 0 || offset < this.lastLineOffset || offset == this.lastLineOffset && !isEof) {
                throw new IllegalArgumentException("Invalid offset " + offset + " (last offset " + this.lastLineOffset + ")");
            }
            this.lastLineOffset = offset;
            if (this.count >= this.buf.length) {
                this.buf = Arrays.copyOf(this.buf, this.buf.length * 2 + 1);
            }
            this.buf[this.count] = offset;
            ++this.count;
        }

        public SourceCodePositioner build(int eofOffset) {
            this.addLineImpl(eofOffset, true);
            int[] finalOffsets = Arrays.copyOf(this.buf, this.count);
            return new SourceCodePositioner(finalOffsets, eofOffset);
        }
    }
}

