/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface FileId
extends Comparable<FileId> {
    public static final FileId UNKNOWN = new FileId(){

        @Override
        public String getFileName() {
            return "(unknown)";
        }

        @Override
        public String getOriginalPath() {
            return "(unknown)";
        }

        @Override
        public String getAbsolutePath() {
            return this.getOriginalPath();
        }

        @Override
        public String getUriString() {
            return "file://" + this.getOriginalPath();
        }

        @Override
        public @Nullable FileId getParentFsPath() {
            return null;
        }

        @Override
        public String toString() {
            return "FileId(unknown)";
        }
    };
    public static final FileId STDIN = new FileId(){

        @Override
        public String getAbsolutePath() {
            return "stdin";
        }

        @Override
        public String getUriString() {
            return "stdin";
        }

        @Override
        public String getFileName() {
            return "stdin";
        }

        @Override
        public String getOriginalPath() {
            return "stdin";
        }

        @Override
        public @Nullable FileId getParentFsPath() {
            return null;
        }

        @Override
        public String toString() {
            return "FileId(STDIN)";
        }
    };

    public String getFileName();

    public String getOriginalPath();

    public String getAbsolutePath();

    public String getUriString();

    public @Nullable FileId getParentFsPath();

    public boolean equals(Object var1);

    @Override
    default public int compareTo(FileId o) {
        return this.getAbsolutePath().compareTo(o.getAbsolutePath());
    }

    public String toString();

    public static FileId fromPathLikeString(final String str) {
        final Path absPath = Paths.get(str, new String[0]).toAbsolutePath();
        final @Nullable Path fileNamePath = absPath.getFileName();
        return new FileId(){
            final String fileName;
            final String absPathStr;
            {
                this.fileName = fileNamePath == null ? "" : fileNamePath.toString();
                this.absPathStr = absPath.toString();
            }

            @Override
            public String getAbsolutePath() {
                return this.absPathStr;
            }

            @Override
            public String getUriString() {
                return "file://" + str;
            }

            @Override
            public String getFileName() {
                return this.fileName;
            }

            @Override
            public String getOriginalPath() {
                return str;
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof FileId && ((FileId)obj).getUriString().equals(this.getUriString());
            }

            public int hashCode() {
                return this.getUriString().hashCode();
            }

            @Override
            public @Nullable FileId getParentFsPath() {
                return null;
            }

            @Override
            public String toString() {
                return "FileId(fromPathLike=" + str + ")";
            }
        };
    }

    public static FileId fromPath(final Path path, final @Nullable FileId fsPath) {
        return new FileId(){
            final String absPath;
            final String uriString;
            final String fileName;
            final String origPath;
            {
                this.absPath = path.normalize().toAbsolutePath().toString();
                this.uriString = path.normalize().toUri().toString();
                this.fileName = path.getFileName().toString();
                this.origPath = path.toString();
            }

            @Override
            public String getAbsolutePath() {
                return this.absPath;
            }

            @Override
            public String getUriString() {
                return this.uriString;
            }

            @Override
            public String getFileName() {
                return this.fileName;
            }

            @Override
            public String getOriginalPath() {
                return this.origPath;
            }

            @Override
            public @Nullable FileId getParentFsPath() {
                return fsPath;
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof FileId && ((FileId)obj).getUriString().equals(this.getUriString());
            }

            public int hashCode() {
                return this.getUriString().hashCode();
            }

            @Override
            public String toString() {
                return "FileId(fromPath=" + path + ")";
            }
        };
    }

    public static FileId fromPath(Path path) {
        return FileId.fromPath(path, null);
    }

    public static FileId asChildOf(final FileId self, final FileId parentFsPath) {
        return new FileId(){

            @Override
            public @Nullable FileId getParentFsPath() {
                return parentFsPath;
            }

            @Override
            public String getUriString() {
                return self.getUriString();
            }

            @Override
            public String getFileName() {
                return self.getFileName();
            }

            @Override
            public String getOriginalPath() {
                return self.getOriginalPath();
            }

            @Override
            public String getAbsolutePath() {
                return self.getAbsolutePath();
            }

            @Override
            public String toString() {
                return "FileId(" + self + ",asChildOf=" + parentFsPath + ")";
            }
        };
    }

    public static FileId fromAbsolutePath(final String absPath, final @Nullable FileId outer) {
        final Path fileName = Paths.get(absPath, new String[0]).getFileName();
        final String platformAbsPath = absPath.replace('/', File.separatorChar);
        String uriAbsPath = platformAbsPath.replace(File.separatorChar, '/');
        final String uriStr = outer != null ? "jar:" + outer.getUriString() + "!" + uriAbsPath : "file://" + uriAbsPath;
        return new FileId(){

            @Override
            public String getFileName() {
                return fileName.toString();
            }

            @Override
            public String getOriginalPath() {
                return absPath;
            }

            @Override
            public String getAbsolutePath() {
                return platformAbsPath;
            }

            @Override
            public String getUriString() {
                return uriStr;
            }

            @Override
            public @Nullable FileId getParentFsPath() {
                return outer;
            }

            @Override
            public boolean equals(Object obj) {
                return obj instanceof FileId && this.getUriString().equals(((FileId)obj).getUriString());
            }

            public int hashCode() {
                return this.getUriString().hashCode();
            }

            @Override
            public String toString() {
                return "FileId(fromAbsolutePath=" + absPath + ",outer=" + outer + ")";
            }
        };
    }

    public static FileId fromURI(String uriStr) throws IllegalArgumentException {
        URI uri = URI.create(uriStr);
        String schemeSpecificPart = uri.getSchemeSpecificPart();
        if ("jar".equals(uri.getScheme())) {
            int split = schemeSpecificPart.lastIndexOf(33);
            if (split == -1) {
                throw new IllegalArgumentException("expected a jar specific path");
            }
            String zipUri = schemeSpecificPart.substring(0, split);
            String localPath = schemeSpecificPart.substring(split + 1);
            FileId outer = FileId.fromURI(zipUri);
            return FileId.fromAbsolutePath(localPath, outer);
        }
        if ("file".equals(uri.getScheme())) {
            Path path = Paths.get(uri);
            return FileId.fromPath(path);
        }
        throw new UnsupportedOperationException("Unknown scheme " + uriStr);
    }
}

