/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.document;

import java.io.IOException;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextPos2d;
import net.sourceforge.pmd.lang.document.TextRegion;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class BaseMappedDocument
implements TextDocument {
    protected final TextDocument base;

    BaseMappedDocument(TextDocument base) {
        this.base = base;
    }

    @Override
    public long getCheckSum() {
        return this.base.getCheckSum();
    }

    @Override
    public FileId getFileId() {
        return this.base.getFileId();
    }

    @Override
    public Chars sliceOriginalText(TextRegion region) {
        return this.base.sliceOriginalText(this.inputRegion(region));
    }

    @Override
    public FileLocation toLocation(TextRegion region) {
        return this.base.toLocation(this.inputRegion(region));
    }

    @Override
    public TextRegion createLineRange(int startLineInclusive, int endLineInclusive) {
        return this.base.createLineRange(startLineInclusive, endLineInclusive);
    }

    @Override
    public TextPos2d lineColumnAtOffset(int offset, boolean inclusive) {
        return this.base.lineColumnAtOffset(this.inputOffset(offset, inclusive));
    }

    @Override
    public int offsetAtLineColumn(TextPos2d position) {
        throw new UnsupportedOperationException();
    }

    protected @NonNull TextRegion inputRegion(TextRegion outputRegion) {
        return TextRegion.fromBothOffsets(this.inputOffset(outputRegion.getStartOffset(), true), this.inputOffset(outputRegion.getEndOffset(), false));
    }

    protected final int inputOffset(int outOffset, boolean inclusive) {
        if (outOffset < 0 || outOffset > this.getLength()) {
            throw new IndexOutOfBoundsException();
        }
        return this.localOffsetTransform(outOffset, inclusive);
    }

    protected abstract int localOffsetTransform(int var1, boolean var2);

    @Override
    public void close() throws IOException {
        this.base.close();
    }
}

