/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import net.sourceforge.pmd.lang.ast.impl.javacc.EscapeTranslator;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.TextDocument;

public abstract class BackslashEscapeTranslator
extends EscapeTranslator {
    private static final char BACKSLASH = '\\';
    private int savedNotEscapeSpecialEnd = Integer.MAX_VALUE;

    public BackslashEscapeTranslator(TextDocument builder) {
        super(builder);
    }

    @Override
    protected int gobbleMaxWithoutEscape(int maxOff) throws MalformedSourceException {
        int off;
        boolean seenBackslash = true;
        int notEscapeEnd = this.savedNotEscapeSpecialEnd;
        for (off = this.bufpos; off < maxOff; ++off) {
            boolean bl = seenBackslash = this.input.charAt(off) == '\\' && notEscapeEnd >= off;
            if (seenBackslash) break;
        }
        if (!seenBackslash || off == maxOff) {
            this.bufpos = off;
            return off;
        }
        return this.handleBackslash(maxOff, off);
    }

    protected abstract int handleBackslash(int var1, int var2) throws MalformedSourceException;

    @Override
    protected int recordEscape(int startOffsetInclusive, int endOffsetExclusive, Chars translation) {
        this.savedNotEscapeSpecialEnd = Integer.MAX_VALUE;
        return super.recordEscape(startOffsetInclusive, endOffsetExclusive, translation);
    }

    protected int abortEscape(int off, int maxOff) {
        int min = Integer.min(maxOff, off);
        this.savedNotEscapeSpecialEnd = min < off ? off : Integer.MAX_VALUE;
        this.bufpos = min;
        return min;
    }
}

