/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.AbstractNode;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.JjtreeNode;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.util.StringUtil;

public abstract class AbstractJjtreeNode<B extends AbstractJjtreeNode<B, N>, N extends JjtreeNode<N>>
extends AbstractNode<B, N>
implements JjtreeNode<N> {
    protected final int id;
    private JavaccToken firstToken;
    private JavaccToken lastToken;
    private String image;

    protected AbstractJjtreeNode(int id) {
        this.id = id;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    protected void setImage(String image) {
        this.image = image;
    }

    @Override
    public final TextRegion getTextRegion() {
        return TextRegion.fromBothOffsets(this.getFirstToken().getStartOffset(), this.getLastToken().getEndOffset());
    }

    @Override
    public final int compareLocation(Node other) {
        if (other instanceof JjtreeNode) {
            return this.getTextRegion().compareTo(((JjtreeNode)other).getTextRegion());
        }
        return super.compareLocation(other);
    }

    protected void jjtOpen() {
    }

    protected void jjtClose() {
    }

    @Override
    protected void addChild(B child, int index) {
        super.addChild(child, index);
    }

    @Override
    protected void insertChild(B child, int index) {
        super.insertChild(child, index);
        this.fitTokensToChildren(index);
    }

    protected void fitTokensToChildren(int index) {
        if (index == 0) {
            this.enlargeLeft((AbstractJjtreeNode)this.getChild(index));
        }
        if (index == this.getNumChildren()) {
            this.enlargeRight((AbstractJjtreeNode)this.getChild(index));
        }
    }

    private void enlargeLeft(B child) {
        JavaccToken thisFst = this.getFirstToken();
        JavaccToken childFst = ((AbstractJjtreeNode)child).getFirstToken();
        if (childFst.compareTo(thisFst) < 0) {
            this.setFirstToken(childFst);
        }
    }

    private void enlargeRight(B child) {
        JavaccToken thisLast = this.getLastToken();
        JavaccToken childLast = ((AbstractJjtreeNode)child).getLastToken();
        if (childLast.compareTo(thisLast) > 0) {
            this.setLastToken(childLast);
        }
    }

    @Override
    public JavaccToken getFirstToken() {
        return this.firstToken;
    }

    @Override
    public JavaccToken getLastToken() {
        return this.lastToken;
    }

    protected void setLastToken(JavaccToken token) {
        this.lastToken = token;
    }

    protected void setFirstToken(JavaccToken token) {
        this.firstToken = token;
    }

    @Override
    public String toString() {
        FileLocation loc = this.getReportLocation();
        return "!debug only! [" + this.getXPathNodeName() + ":" + loc.getStartPos().toDisplayStringWithColon() + "]" + StringUtil.elide(this.getText().toString(), 150, "(truncated)");
    }
}

