/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.TokenEntry;

class MatchCollector {
    private final List<Match> matchList = new ArrayList<Match>();
    private final Map<Integer, Map<Integer, Match>> matchTree = new TreeMap<Integer, Map<Integer, Match>>();
    private final MatchAlgorithm ma;

    MatchCollector(MatchAlgorithm ma) {
        this.ma = ma;
    }

    public void collect(List<TokenEntry> marks) {
        for (int i = 0; i < marks.size() - 1; ++i) {
            TokenEntry mark1 = marks.get(i);
            for (int j = i + 1; j < marks.size(); ++j) {
                int dupes;
                TokenEntry mark2 = marks.get(j);
                int diff = mark1.getIndex() - mark2.getIndex();
                if (-diff < this.ma.getMinimumTileSize() || this.hasPreviousDupe(mark1, mark2) || (dupes = this.countDuplicateTokens(mark1, mark2)) < this.ma.getMinimumTileSize() || diff + dupes >= 1) continue;
                this.reportMatch(mark1, mark2, dupes);
            }
        }
    }

    private void reportMatch(TokenEntry mark1, TokenEntry mark2, int dupes) {
        this.matchTree.compute(dupes, (dupCount, matches) -> {
            if (matches == null) {
                matches = new TreeMap<Integer, Match>();
                this.addNewMatch(mark1, mark2, (int)dupCount, (Map<Integer, Match>)matches);
            } else {
                Match matchA = (Match)matches.get(mark1.getIndex());
                Match matchB = (Match)matches.get(mark2.getIndex());
                if (matchA == null && matchB == null) {
                    this.addNewMatch(mark1, mark2, dupes, (Map<Integer, Match>)matches);
                } else if (matchA == null) {
                    matchB.addMark(mark1);
                    matches.put(mark1.getIndex(), matchB);
                } else if (matchB == null) {
                    matchA.addMark(mark2);
                    matches.put(mark2.getIndex(), matchA);
                }
            }
            return matches;
        });
    }

    private void addNewMatch(TokenEntry mark1, TokenEntry mark2, int dupes, Map<Integer, Match> matches) {
        Match match = new Match(dupes, mark1, mark2);
        matches.put(mark1.getIndex(), match);
        matches.put(mark2.getIndex(), match);
        this.matchList.add(match);
    }

    List<Match> getMatches() {
        return this.matchList;
    }

    private boolean hasPreviousDupe(TokenEntry mark1, TokenEntry mark2) {
        return mark1.getIndex() != 0 && !this.matchEnded(this.ma.tokenAt(-1, mark1), this.ma.tokenAt(-1, mark2));
    }

    private int countDuplicateTokens(TokenEntry mark1, TokenEntry mark2) {
        int index = 0;
        while (!this.matchEnded(this.ma.tokenAt(index, mark1), this.ma.tokenAt(index, mark2))) {
            ++index;
        }
        return index;
    }

    private boolean matchEnded(TokenEntry token1, TokenEntry token2) {
        return token1.getIdentifier() != token2.getIdentifier() || token1.isEof() || token2.isEof();
    }
}

