/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileId;

public class CPDReport {
    private final SourceManager sourceManager;
    private final List<Match> matches;
    private final Map<FileId, Integer> numberOfTokensPerFile;

    CPDReport(SourceManager sourceManager, List<Match> matches, Map<FileId, Integer> numberOfTokensPerFile) {
        this.sourceManager = sourceManager;
        this.matches = Collections.unmodifiableList(matches);
        this.numberOfTokensPerFile = Collections.unmodifiableMap(new TreeMap<FileId, Integer>(numberOfTokensPerFile));
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    public Map<FileId, Integer> getNumberOfTokensPerFile() {
        return this.numberOfTokensPerFile;
    }

    public Chars getSourceCodeSlice(Mark mark) {
        return this.sourceManager.getSlice(mark);
    }

    public CPDReport filterMatches(Predicate<Match> filter) {
        List<Match> filtered = this.matches.stream().filter(filter).collect(Collectors.toList());
        return new CPDReport(this.sourceManager, filtered, this.getNumberOfTokensPerFile());
    }

    public String getDisplayName(FileId fileId) {
        return this.sourceManager.getFileDisplayName(fileId);
    }
}

