/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.treeexport;

import java.io.IOException;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.util.treeexport.TreeRenderersTest;
import net.sourceforge.pmd.util.treeexport.XmlTreeRenderer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class XmlTreeRendererTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    XmlTreeRendererTest() {
    }

    DummyNode dummyTree1() {
        return TreeRenderersTest.dummyTree1(this.helper);
    }

    @Test
    void testRenderWithAttributes() throws IOException {
        DummyNode dummy = this.dummyTree1();
        XmlTreeRenderer.XmlRenderingConfig strat = new XmlTreeRenderer.XmlRenderingConfig();
        strat.lineSeparator("\n");
        XmlTreeRenderer renderer = new XmlTreeRenderer(strat);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<?xml version='1.0' encoding='UTF-8' ?>\n<dummyNode foo='bar' ohio='4'>\n    <dummyNode o='ha' />\n    <dummyNode />\n</dummyNode>\n", (Object)out.toString());
    }

    @Test
    void testRenderWithCustomLineSep() throws IOException {
        DummyNode dummy = this.dummyTree1();
        XmlTreeRenderer.XmlRenderingConfig strat = new XmlTreeRenderer.XmlRenderingConfig();
        strat.lineSeparator("\r\n");
        XmlTreeRenderer renderer = new XmlTreeRenderer(strat);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<?xml version='1.0' encoding='UTF-8' ?>\r\n<dummyNode foo='bar' ohio='4'>\r\n    <dummyNode o='ha' />\r\n    <dummyNode />\r\n</dummyNode>\r\n", (Object)out.toString());
    }

    @Test
    void testRenderWithCustomIndent() throws IOException {
        DummyNode dummy = this.dummyTree1();
        XmlTreeRenderer.XmlRenderingConfig strat = new XmlTreeRenderer.XmlRenderingConfig().lineSeparator("").indentWith("");
        XmlTreeRenderer renderer = new XmlTreeRenderer(strat);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<?xml version='1.0' encoding='UTF-8' ?><dummyNode foo='bar' ohio='4'><dummyNode o='ha' /><dummyNode /></dummyNode>", (Object)out.toString());
    }

    @Test
    void testRenderWithNoAttributes() throws IOException {
        DummyNode dummy = this.dummyTree1();
        XmlTreeRenderer.XmlRenderingConfig strat = new XmlTreeRenderer.XmlRenderingConfig(){

            public boolean takeAttribute(Node node, Attribute attribute) {
                return false;
            }
        }.lineSeparator("\n");
        XmlTreeRenderer renderer = new XmlTreeRenderer(strat);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<?xml version='1.0' encoding='UTF-8' ?>\n<dummyNode>\n    <dummyNode />\n    <dummyNode />\n</dummyNode>\n", (Object)out.toString());
    }

    @Test
    void testRenderFilterAttributes() throws IOException {
        DummyNode dummy = this.dummyTree1();
        XmlTreeRenderer.XmlRenderingConfig strategy = new XmlTreeRenderer.XmlRenderingConfig(){

            public boolean takeAttribute(Node node, Attribute attribute) {
                return attribute.getName().equals("ohio");
            }
        }.lineSeparator("\n");
        XmlTreeRenderer renderer = new XmlTreeRenderer(strategy);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<?xml version='1.0' encoding='UTF-8' ?>\n<dummyNode ohio='4'>\n    <dummyNode />\n    <dummyNode />\n</dummyNode>\n", (Object)out.toString());
    }

    @Test
    void testInvalidAttributeName() throws IOException {
        DummyNode dummy = this.dummyTree1();
        dummy.setXPathAttribute("&notAName", "foo");
        XmlTreeRenderer.XmlRenderingConfig config = new XmlTreeRenderer.XmlRenderingConfig();
        config.lineSeparator("\n");
        XmlTreeRenderer renderer = new XmlTreeRenderer(config);
        StringBuilder out = new StringBuilder();
        Assertions.assertThrows(IllegalArgumentException.class, () -> renderer.renderSubtree((Node)dummy, (Appendable)out));
    }

    @Test
    void testEscapeAttributes() throws IOException {
        DummyNode dummy = this.dummyTree1();
        dummy.setXPathAttribute("eh", " 'a &> b\" ");
        XmlTreeRenderer.XmlRenderingConfig strat = new XmlTreeRenderer.XmlRenderingConfig().lineSeparator("\n");
        XmlTreeRenderer renderer = new XmlTreeRenderer(strat);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<?xml version='1.0' encoding='UTF-8' ?>\n<dummyNode eh=' &apos;a &amp;> b\" ' foo='bar' ohio='4'>\n    <dummyNode o='ha' />\n    <dummyNode />\n</dummyNode>\n", (Object)out.toString());
    }

    @Test
    void testEscapeDoubleAttributes() throws IOException {
        DummyNode dummy = this.dummyTree1();
        dummy.setXPathAttribute("eh", " 'a &> b\" ");
        XmlTreeRenderer.XmlRenderingConfig strat = new XmlTreeRenderer.XmlRenderingConfig().lineSeparator("\n").singleQuoteAttributes(false);
        XmlTreeRenderer renderer = new XmlTreeRenderer(strat);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<dummyNode eh=\" 'a &amp;> b&quot; \" foo=\"bar\" ohio=\"4\">\n    <dummyNode o=\"ha\" />\n    <dummyNode />\n</dummyNode>\n", (Object)out.toString());
    }

    @Test
    void testNoProlog() throws IOException {
        DummyNode dummy = this.dummyTree1();
        XmlTreeRenderer.XmlRenderingConfig strat = new XmlTreeRenderer.XmlRenderingConfig().lineSeparator("\n").renderProlog(false);
        XmlTreeRenderer renderer = new XmlTreeRenderer(strat);
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)"<dummyNode foo='bar' ohio='4'>\n    <dummyNode o='ha' />\n    <dummyNode />\n</dummyNode>\n", (Object)out.toString());
    }

    @Test
    void testDefaultLineSep() throws IOException {
        DummyNode dummy = this.dummyTree1();
        XmlTreeRenderer renderer = new XmlTreeRenderer();
        StringBuilder out = new StringBuilder();
        renderer.renderSubtree((Node)dummy, (Appendable)out);
        Assertions.assertEquals((Object)("<?xml version='1.0' encoding='UTF-8' ?>" + System.lineSeparator() + "<dummyNode foo='bar' ohio='4'>" + System.lineSeparator() + "    <dummyNode o='ha' />" + System.lineSeparator() + "    <dummyNode />" + System.lineSeparator() + "</dummyNode>" + System.lineSeparator()), (Object)out.toString());
    }
}

