/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import net.sourceforge.pmd.util.database.DBType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class DBTypeTest {
    private File absoluteFile;
    private Properties testProperties;
    private Properties includeProperties;
    @TempDir
    private Path folder;

    DBTypeTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.testProperties = new Properties();
        this.testProperties.put("prop1", "value1");
        this.testProperties.put("prop2", "value2");
        this.testProperties.put("prop3", "value3");
        this.includeProperties = new Properties();
        this.includeProperties.putAll((Map<?, ?>)this.testProperties);
        this.includeProperties.put("prop3", "include3");
        this.absoluteFile = this.folder.resolve("dbtypetest.properties").toFile();
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.absoluteFile);
             PrintStream printStream = new PrintStream(fileOutputStream);){
            for (Map.Entry<Object, Object> entry : this.testProperties.entrySet()) {
                printStream.printf("%s=%s\n", entry.getKey(), entry.getValue());
            }
        }
    }

    @AfterEach
    void tearDown() throws Exception {
        this.testProperties = null;
    }

    @Test
    void testGetPropertiesFromFile() throws Exception {
        System.out.println("getPropertiesFromFile");
        DBType instance = new DBType(this.absoluteFile.getAbsolutePath());
        Properties expResult = this.testProperties;
        Properties result = instance.getProperties();
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testGetProperties() throws Exception {
        System.out.println("testGetProperties");
        DBType instance = new DBType("test");
        Properties expResult = this.testProperties;
        System.out.println("testGetProperties: expected results " + this.testProperties);
        Properties result = instance.getProperties();
        System.out.println("testGetProperties: actual results " + result);
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testGetIncludeProperties() throws Exception {
        System.out.println("testGetIncludeProperties");
        DBType instance = new DBType("include");
        Properties expResult = this.includeProperties;
        System.out.println("testGetIncludeProperties: expected results " + this.includeProperties);
        Properties result = instance.getProperties();
        System.out.println("testGetIncludeProperties: actual results " + result);
        Assertions.assertEquals((Object)expResult, (Object)result);
    }

    @Test
    void testAsProperties() {
        System.out.println("asProperties");
        ResourceBundle bundle = ResourceBundle.getBundle(DBType.class.getPackage().getName() + ".test");
        Properties expResult = this.testProperties;
        Properties result = DBType.getResourceBundleAsProperties((ResourceBundle)bundle);
        Assertions.assertEquals((Object)expResult, (Object)result);
    }
}

