/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.stream.Stream;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.util.StringUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class StringUtilTest {
    StringUtilTest() {
    }

    @Test
    void testColumnNumber() {
        Assertions.assertEquals((int)-1, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)-1));
        Assertions.assertEquals((int)1, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)0));
        Assertions.assertEquals((int)2, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)1));
        Assertions.assertEquals((int)1, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)2));
        Assertions.assertEquals((int)2, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)3));
        Assertions.assertEquals((int)3, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)4));
        Assertions.assertEquals((int)1, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)5));
        Assertions.assertEquals((int)2, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)6));
        Assertions.assertEquals((int)-1, (int)StringUtil.columnNumberAt((CharSequence)"f\rah\nb", (int)7));
    }

    @Test
    void testColumnNumberCrLf() {
        Assertions.assertEquals((int)-1, (int)StringUtil.columnNumberAt((CharSequence)"f\r\nb", (int)-1));
        Assertions.assertEquals((int)1, (int)StringUtil.columnNumberAt((CharSequence)"f\r\nb", (int)0));
        Assertions.assertEquals((int)2, (int)StringUtil.columnNumberAt((CharSequence)"f\r\nb", (int)1));
        Assertions.assertEquals((int)3, (int)StringUtil.columnNumberAt((CharSequence)"f\r\nb", (int)2));
        Assertions.assertEquals((int)1, (int)StringUtil.columnNumberAt((CharSequence)"f\r\nb", (int)3));
        Assertions.assertEquals((int)2, (int)StringUtil.columnNumberAt((CharSequence)"f\r\nb", (int)4));
        Assertions.assertEquals((int)-1, (int)StringUtil.columnNumberAt((CharSequence)"f\r\nb", (int)5));
    }

    @Test
    void testColumnNumberTrailing() {
        Assertions.assertEquals((int)1, (int)StringUtil.columnNumberAt((CharSequence)"\n", (int)0));
        Assertions.assertEquals((int)2, (int)StringUtil.columnNumberAt((CharSequence)"\n", (int)1));
        Assertions.assertEquals((int)-1, (int)StringUtil.columnNumberAt((CharSequence)"\n", (int)2));
    }

    @Test
    void testColumnNumberEmpty() {
        Assertions.assertEquals((int)1, (int)StringUtil.columnNumberAt((CharSequence)"", (int)0));
        Assertions.assertEquals((int)-1, (int)StringUtil.columnNumberAt((CharSequence)"", (int)1));
    }

    @Test
    void testRemoveSurrounding() {
        MatcherAssert.assertThat((Object)StringUtil.removeSurrounding((String)"", (char)'q'), (Matcher)CoreMatchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)StringUtil.removeSurrounding((String)"q", (char)'q'), (Matcher)CoreMatchers.equalTo((Object)"q"));
        MatcherAssert.assertThat((Object)StringUtil.removeSurrounding((String)"qq", (char)'q'), (Matcher)CoreMatchers.equalTo((Object)""));
        MatcherAssert.assertThat((Object)StringUtil.removeSurrounding((String)"qqq", (char)'q'), (Matcher)CoreMatchers.equalTo((Object)"q"));
    }

    @Test
    void testTrimIndent() {
        this.assertTrimIndent(" \n b \n c", "\nb\nc");
        this.assertTrimIndent(" \nb \n c", "\nb\n c");
        this.assertTrimIndent(" \n b \n c\n  ", "\nb\nc\n");
        this.assertTrimIndent("", "");
    }

    private void assertTrimIndent(String input, String output) {
        String actual = StringUtil.trimIndent((Chars)Chars.wrap((CharSequence)input)).toString();
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.equalTo((Object)output));
    }

    @Test
    void testElide() {
        MatcherAssert.assertThat((Object)StringUtil.elide((String)"abc", (int)2, (String)""), (Matcher)CoreMatchers.equalTo((Object)"ab"));
        MatcherAssert.assertThat((Object)StringUtil.elide((String)"abc", (int)2, (String)"."), (Matcher)CoreMatchers.equalTo((Object)"a."));
        MatcherAssert.assertThat((Object)StringUtil.elide((String)"abc", (int)2, (String)".."), (Matcher)CoreMatchers.equalTo((Object)".."));
        MatcherAssert.assertThat((Object)StringUtil.elide((String)"abc", (int)3, (String)".."), (Matcher)CoreMatchers.equalTo((Object)"abc"));
    }

    @Test
    void substringAfterLast() {
        Assertions.assertEquals((Object)"abc", (Object)StringUtil.substringAfterLast((String)"a.abc", (int)46));
        Assertions.assertEquals((Object)"abc", (Object)StringUtil.substringAfterLast((String)"abc", (int)46));
    }

    @Test
    void caseConventionCamelCaseToScreamingSnake() {
        Assertions.assertEquals((Object)"rootDirectory", (Object)StringUtil.CaseConvention.SCREAMING_SNAKE_CASE.convertTo(StringUtil.CaseConvention.CAMEL_CASE, "ROOT_DIRECTORY"));
        Assertions.assertEquals((Object)"ROOT_DIRECTORY", (Object)StringUtil.CaseConvention.CAMEL_CASE.convertTo(StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, "rootDirectory"));
    }

    @ParameterizedTest
    @MethodSource
    void caseConventionConvertTo(CaseConventionConversionTestData data) {
        Assertions.assertEquals((Object)data.expected, (Object)data.from.convertTo(data.to, data.source));
    }

    private static Stream<CaseConventionConversionTestData> caseConventionConvertTo() {
        return Stream.of(new CaseConventionConversionTestData(StringUtil.CaseConvention.CAMEL_CASE, StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, "camelCase", "CAMEL_CASE"), new CaseConventionConversionTestData(StringUtil.CaseConvention.CAMEL_CASE, StringUtil.CaseConvention.PASCAL_CASE, "camelCase", "CamelCase"), new CaseConventionConversionTestData(StringUtil.CaseConvention.CAMEL_CASE, StringUtil.CaseConvention.SPACE_SEPARATED, "camelCase", "camel case"), new CaseConventionConversionTestData(StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, StringUtil.CaseConvention.CAMEL_CASE, "SCREAMING_SNAKE_CASE", "screamingSnakeCase"), new CaseConventionConversionTestData(StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, StringUtil.CaseConvention.PASCAL_CASE, "SCREAMING_SNAKE_CASE", "ScreamingSnakeCase"), new CaseConventionConversionTestData(StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, StringUtil.CaseConvention.SPACE_SEPARATED, "SCREAMING_SNAKE_CASE", "screaming snake case"), new CaseConventionConversionTestData(StringUtil.CaseConvention.PASCAL_CASE, StringUtil.CaseConvention.CAMEL_CASE, "PascalCase", "pascalCase"), new CaseConventionConversionTestData(StringUtil.CaseConvention.PASCAL_CASE, StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, "PascalCase", "PASCAL_CASE"), new CaseConventionConversionTestData(StringUtil.CaseConvention.PASCAL_CASE, StringUtil.CaseConvention.SPACE_SEPARATED, "PascalCase", "pascal case"), new CaseConventionConversionTestData(StringUtil.CaseConvention.SPACE_SEPARATED, StringUtil.CaseConvention.CAMEL_CASE, "space separated", "spaceSeparated"), new CaseConventionConversionTestData(StringUtil.CaseConvention.SPACE_SEPARATED, StringUtil.CaseConvention.SCREAMING_SNAKE_CASE, "space separated", "SPACE_SEPARATED"), new CaseConventionConversionTestData(StringUtil.CaseConvention.SPACE_SEPARATED, StringUtil.CaseConvention.PASCAL_CASE, "space separated", "SpaceSeparated"));
    }

    private static class CaseConventionConversionTestData {
        StringUtil.CaseConvention from;
        StringUtil.CaseConvention to;
        String source;
        String expected;

        CaseConventionConversionTestData(StringUtil.CaseConvention from, StringUtil.CaseConvention to, String source, String expected) {
            this.from = from;
            this.to = to;
            this.source = source;
            this.expected = expected;
        }

        public String toString() {
            return this.source + "(" + this.from.name() + "->" + this.to.name() + ")=" + this.expected;
        }
    }
}

