/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.pmd.util.IteratorUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class IteratorUtilTest {
    IteratorUtilTest() {
    }

    @Test
    void testAnyMatchPos() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "cd");
        boolean match = IteratorUtil.anyMatch(iter, it -> it.length() > 1);
        Assertions.assertTrue((boolean)match);
    }

    @Test
    void testAnyMatchNeg() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "");
        boolean match = IteratorUtil.anyMatch(iter, it -> it.length() > 1);
        Assertions.assertFalse((boolean)match);
    }

    @Test
    void testAnyMatchEmpty() {
        Iterator iter = Collections.emptyIterator();
        boolean match = IteratorUtil.anyMatch(iter, it -> it.length() > 1);
        Assertions.assertFalse((boolean)match);
    }

    @Test
    void testAllMatchPos() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ap", "bcd", "cd");
        boolean match = IteratorUtil.allMatch(iter, it -> it.length() > 1);
        Assertions.assertTrue((boolean)match);
    }

    @Test
    void testAllMatchNeg() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "bcd", "");
        boolean match = IteratorUtil.allMatch(iter, it -> it.length() > 1);
        Assertions.assertFalse((boolean)match);
    }

    @Test
    void testAllMatchEmpty() {
        Iterator iter = Collections.emptyIterator();
        boolean match = IteratorUtil.allMatch(iter, it -> it.length() > 1);
        Assertions.assertTrue((boolean)match);
    }

    @Test
    void testNoneMatchPos() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ap", "bcd", "cd");
        boolean match = IteratorUtil.noneMatch(iter, it -> it.length() < 1);
        Assertions.assertTrue((boolean)match);
    }

    @Test
    void testNoneMatchNeg() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "bcd", "");
        boolean match = IteratorUtil.noneMatch(iter, it -> it.length() < 1);
        Assertions.assertFalse((boolean)match);
    }

    @Test
    void testNoneMatchEmpty() {
        Iterator iter = Collections.emptyIterator();
        boolean match = IteratorUtil.noneMatch(iter, it -> it.length() < 1);
        Assertions.assertTrue((boolean)match);
    }

    @Test
    void testFlatmap() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "cd", "e", "", "f");
        Function<String, Iterator> fun = s -> s.chars().mapToObj(i -> Character.valueOf((char)i)).map(String::valueOf).iterator();
        Iterator mapped = IteratorUtil.flatMap(iter, fun);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"a", "b", "c", "d", "e", "f"}));
    }

    @Test
    void testFlatmapEmpty() {
        Iterator iter = Collections.emptyIterator();
        Function<String, Iterator> fun = s -> s.chars().mapToObj(i -> Character.valueOf((char)i)).map(String::valueOf).iterator();
        Iterator mapped = IteratorUtil.flatMap(iter, fun);
        this.assertExhausted(mapped);
    }

    @Test
    void testFlatmapEmpty2() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "cd", "e", "", "f");
        Function<String, Iterator> fun = s -> Collections.emptyIterator();
        Iterator mapped = IteratorUtil.flatMap(iter, fun);
        this.assertExhausted(mapped);
    }

    @Test
    void testFlatmapIsLazy() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b");
        Function<String, Iterator> fun = s -> {
            if (s.equals("a")) {
                return IteratorUtilTest.iterOf("a");
            }
            throw new AssertionError((Object)"This statement shouldn't be reached");
        };
        Iterator mapped = IteratorUtil.flatMap(iter, fun);
        Assertions.assertTrue((boolean)mapped.hasNext());
        Assertions.assertEquals((Object)"a", mapped.next());
        Assertions.assertThrows(AssertionError.class, () -> mapped.hasNext());
    }

    @Test
    void testFlatmapWithSelf() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "e", null, "f");
        Function<String, Iterator> fun = s -> s == null ? null : IteratorUtilTest.iterOf(s + "1", s + "2");
        Iterator mapped = IteratorUtil.flatMapWithSelf(iter, fun);
        MatcherAssert.assertThat((Object)IteratorUtil.toList((Iterator)mapped), (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ab", "ab1", "ab2", "e", "e1", "e2", null, "f", "f1", "f2"}));
    }

    @Test
    void testMapNotNull() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "cdde", "e", "", "f", "fe");
        Function<String, Integer> fun = s -> s.length() < 2 ? null : Integer.valueOf(s.length());
        Iterator mapped = IteratorUtil.mapNotNull(iter, fun);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new Integer[]{2, 4, 2}));
    }

    @Test
    void testMapNotNullEmpty() {
        Iterator iter = Collections.emptyIterator();
        Function<String, Integer> fun = s -> s.length() < 2 ? null : Integer.valueOf(s.length());
        Iterator mapped = IteratorUtil.mapNotNull(iter, fun);
        this.assertExhausted(mapped);
    }

    @Test
    void testMapNotNullEmpty2() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b");
        Function<String, Iterator> fun = s -> null;
        Iterator mapped = IteratorUtil.flatMap(iter, fun);
        this.assertExhausted(mapped);
    }

    @Test
    void testFilterNotNull() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", null, "e", null, "", "fe");
        Iterator mapped = IteratorUtil.filterNotNull(iter);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ab", "e", "", "fe"}));
        this.assertExhausted(iter);
    }

    @Test
    void testDistinct() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", null, "e", null, "fe", "ab", "c");
        Iterator mapped = IteratorUtil.distinct(iter);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ab", null, "e", "fe", "c"}));
        this.assertExhausted(iter);
    }

    @Test
    void testTakeWhile() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "null", "e", null, "", "fe");
        Predicate<String> predicate = Objects::nonNull;
        Iterator mapped = IteratorUtil.takeWhile(iter, predicate);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ab", "null", "e"}));
        this.assertExhausted(mapped);
    }

    @Test
    void testTakeWhileWithEmpty() {
        Iterator<String> iter = IteratorUtilTest.iterOf(new String[0]);
        Predicate<String> predicate = Objects::nonNull;
        Iterator mapped = IteratorUtil.takeWhile(iter, predicate);
        this.assertExhausted(mapped);
    }

    @Test
    void testPeek() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", null, "c");
        ArrayList seen = new ArrayList();
        Consumer<String> action = seen::add;
        Iterator mapped = IteratorUtil.peek(iter, action);
        Assertions.assertEquals((Object)"ab", mapped.next());
        MatcherAssert.assertThat(seen, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ab"}));
        Assertions.assertNull(mapped.next());
        MatcherAssert.assertThat(seen, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ab", null}));
        Assertions.assertEquals((Object)"c", mapped.next());
        MatcherAssert.assertThat(seen, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"ab", null, "c"}));
        this.assertExhausted(mapped);
    }

    @Test
    void testTakeNegative() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtil.take((Iterator)iter, (int)-5));
    }

    @Test
    void testTake0() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Iterator mapped = IteratorUtil.take(iter, (int)0);
        this.assertExhausted(mapped);
    }

    @Test
    void testTake() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Iterator mapped = IteratorUtil.take(iter, (int)1);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"a"}));
        this.assertExhausted(mapped);
    }

    @Test
    void testTakeOverflow() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Iterator mapped = IteratorUtil.take(iter, (int)12);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"a", "b", "c"}));
        this.assertExhausted(mapped);
    }

    @Test
    void testDropNegative() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtil.advance((Iterator)iter, (int)-5));
    }

    @Test
    void testDrop0() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Iterator mapped = IteratorUtil.drop(iter, (int)0);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"a", "b", "c"}));
        this.assertExhausted(mapped);
    }

    @Test
    void testDrop() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Iterator mapped = IteratorUtil.drop(iter, (int)1);
        MatcherAssert.assertThat(() -> mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"b", "c"}));
        this.assertExhausted(mapped);
    }

    @Test
    void testDropOverflow() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Iterator mapped = IteratorUtil.drop(iter, (int)12);
        this.assertExhausted(mapped);
    }

    @Test
    void testGetNegative() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtil.getNth((Iterator)iter, (int)-5));
    }

    @Test
    void testGet0() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        String elt = (String)IteratorUtil.getNth(iter, (int)0);
        Assertions.assertEquals((Object)"a", (Object)elt);
    }

    @Test
    void testGetNth() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        String elt = (String)IteratorUtil.getNth(iter, (int)1);
        Assertions.assertEquals((Object)"b", (Object)elt);
    }

    @Test
    void testGetOverflow() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        String elt = (String)IteratorUtil.getNth(iter, (int)12);
        Assertions.assertNull((Object)elt);
    }

    @Test
    void testLast() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        String elt = (String)IteratorUtil.last(iter);
        Assertions.assertEquals((Object)"c", (Object)elt);
        this.assertExhausted(iter);
    }

    @Test
    void testLastEmpty() {
        Iterator iter = Collections.emptyIterator();
        String elt = (String)IteratorUtil.last(iter);
        Assertions.assertNull((Object)elt);
    }

    @Test
    void testCount() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        int size = IteratorUtil.count(iter);
        Assertions.assertEquals((int)size, (int)3);
        this.assertExhausted(iter);
    }

    @Test
    void testCountEmpty() {
        Iterator iter = Collections.emptyIterator();
        int size = IteratorUtil.count(iter);
        Assertions.assertEquals((int)size, (int)0);
    }

    @Test
    void testToList() {
        Iterator<String> iter = IteratorUtilTest.iterOf("a", "b", "c");
        List lst = IteratorUtil.toList(iter);
        Assertions.assertEquals((Object)lst, IteratorUtilTest.listOf("a", "b", "c"));
        this.assertExhausted(iter);
    }

    @Test
    void testAsReversed() {
        List<String> iter = IteratorUtilTest.listOf("a", "b", "c");
        Iterable mapped = IteratorUtil.asReversed(iter);
        MatcherAssert.assertThat((Object)mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c", "b", "a"}));
    }

    @Test
    void testAsReversedIsRepeatable() {
        List<String> iter = IteratorUtilTest.listOf("a", "b", "c");
        Iterable mapped = IteratorUtil.asReversed(iter);
        MatcherAssert.assertThat((Object)mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c", "b", "a"}));
        MatcherAssert.assertThat((Object)mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c", "b", "a"}));
        MatcherAssert.assertThat((Object)mapped, (Matcher)IsIterableContainingInOrder.contains((Object[])new String[]{"c", "b", "a"}));
    }

    @Test
    void testDropLast() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "cdde", "e", "", "f", "fe");
        Iterator dropped = IteratorUtil.dropLast(iter, (int)2);
        Assertions.assertEquals(IteratorUtilTest.listOf("ab", "cdde", "e", ""), (Object)IteratorUtil.toList((Iterator)dropped));
    }

    @Test
    void testDropLastOne() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "cdde", "e", "", "f", "fe");
        Iterator dropped = IteratorUtil.dropLast(iter, (int)1);
        Assertions.assertEquals(IteratorUtilTest.listOf("ab", "cdde", "e", "", "f"), (Object)IteratorUtil.toList((Iterator)dropped));
    }

    @Test
    void testDropMoreThanSize() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "c");
        Iterator dropped = IteratorUtil.dropLast(iter, (int)4);
        Assertions.assertEquals(Collections.emptyList(), (Object)IteratorUtil.toList((Iterator)dropped));
    }

    @Test
    void testDropLastZero() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "c");
        Iterator dropped = IteratorUtil.dropLast(iter, (int)0);
        Assertions.assertEquals(IteratorUtilTest.listOf("ab", "c"), (Object)IteratorUtil.toList((Iterator)dropped));
    }

    @Test
    void testDropLastNegative() {
        Iterator<String> iter = IteratorUtilTest.iterOf("ab", "c");
        Assertions.assertThrows(IllegalArgumentException.class, () -> IteratorUtil.dropLast((Iterator)iter, (int)-3));
    }

    private void assertExhausted(Iterator<?> mapped) {
        Assertions.assertFalse((boolean)mapped.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> mapped.next());
    }

    static <T> Iterator<T> iterOf(T ... ts) {
        return Arrays.asList(ts).iterator();
    }

    static <T> List<T> listOf(T ... ts) {
        return Arrays.asList(ts);
    }
}

