/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.Comparator;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.ParametricRuleViolation;
import net.sourceforge.pmd.reporting.ReportTest;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class RuleViolationTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();
    private FileId filename = FileId.fromPathLikeString((String)"filename");

    RuleViolationTest() {
    }

    @Test
    void testConstructor1() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        DummyNode.DummyRootNode s = this.helper.parse("abcd", this.filename);
        ParametricRuleViolation r = new ParametricRuleViolation((Rule)rule, (Reportable)s, rule.getMessage());
        Assertions.assertEquals((Object)((Object)rule), (Object)r.getRule(), (String)"object mismatch");
        Assertions.assertEquals((int)1, (int)r.getBeginLine(), (String)"line number is wrong");
        Assertions.assertSame((Object)this.filename, (Object)r.getFileId(), (String)"filename is wrong");
    }

    @Test
    void testConstructor2() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        DummyNode.DummyRootNode s = this.helper.parse("abcd", this.filename);
        ParametricRuleViolation r = new ParametricRuleViolation((Rule)rule, (Reportable)s, "description");
        Assertions.assertEquals((Object)((Object)rule), (Object)r.getRule(), (String)"object mismatch");
        Assertions.assertEquals((int)1, (int)r.getBeginLine(), (String)"line number is wrong");
        Assertions.assertSame((Object)this.filename, (Object)r.getFileId(), (String)"filename is wrong");
        Assertions.assertEquals((Object)"description", (Object)r.getDescription(), (String)"description is wrong");
    }

    @Test
    void testComparatorWithDifferentFilenames() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        Comparator comp = RuleViolation.DEFAULT_COMPARATOR;
        DummyNode s = (DummyNode)this.helper.parse("(abc)", FileId.fromPathLikeString((String)"f1")).getFirstChild();
        DummyNode s1 = (DummyNode)this.helper.parse("(abc)", FileId.fromPathLikeString((String)"f2")).getFirstChild();
        ParametricRuleViolation r1 = new ParametricRuleViolation((Rule)rule, (Reportable)s, "description");
        ParametricRuleViolation r2 = new ParametricRuleViolation((Rule)rule, (Reportable)s1, "description");
        Assertions.assertEquals((int)-1, (int)comp.compare(r1, r2));
        Assertions.assertEquals((int)1, (int)comp.compare(r2, r1));
    }

    @Test
    void testComparatorWithSameFileDifferentLines() {
        DummyNode defChild;
        ParametricRuleViolation r2;
        Comparator comp = RuleViolation.DEFAULT_COMPARATOR;
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        DummyNode.DummyRootNode root = this.helper.parse("(abc) (def)");
        DummyNode abcChild = (DummyNode)root.getChild(0);
        ParametricRuleViolation r1 = new ParametricRuleViolation((Rule)rule, (Reportable)abcChild, "description");
        Assertions.assertTrue((comp.compare(r1, r2 = new ParametricRuleViolation((Rule)rule, (Reportable)(defChild = (DummyNode)root.getChild(1)), "description")) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((comp.compare(r2, r1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testComparatorWithSameFileSameLines() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        Comparator comp = RuleViolation.DEFAULT_COMPARATOR;
        FileLocation loc = FileLocation.range((FileId)this.filename, (TextRange2d)TextRange2d.range2d((int)10, (int)1, (int)15, (int)10));
        RuleViolation r1 = ReportTest.violation((Rule)rule, loc, "description");
        RuleViolation r2 = ReportTest.violation((Rule)rule, loc, "description");
        Assertions.assertEquals((int)0, (int)comp.compare(r1, r2));
        Assertions.assertEquals((int)0, (int)comp.compare(r2, r1));
    }
}

