/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.DummyTreeUtil;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ReportTestUtil;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RuleContextTest {
    RuleContextTest() {
    }

    @Test
    void testMessage() throws Exception {
        Report report = ReportTestUtil.getReport((Rule)new FooRule(), (r, ctx) -> ctx.addViolationWithMessage((Node)DummyTreeUtil.tree(() -> DummyTreeUtil.root(new DummyNode[0])), "message with \"'{'\""));
        Assertions.assertEquals((Object)"message with \"{\"", (Object)((RuleViolation)report.getViolations().get(0)).getDescription());
    }

    @Test
    void testMessageEscaping() throws Exception {
        RuleViolation violation = this.makeViolation("message with \"'{'\"", new Object[0]);
        Assertions.assertEquals((Object)"message with \"{\"", (Object)violation.getDescription());
    }

    @Test
    void testMessageEscaping2() throws Exception {
        RuleViolation violation = this.makeViolation("message with ${ohio}", new Object[0]);
        Assertions.assertEquals((Object)"message with ${ohio}", (Object)violation.getDescription());
    }

    private RuleViolation makeViolation(String unescapedMessage, Object ... args) throws Exception {
        Report report = ReportTestUtil.getReport((Rule)new FooRule(), (r, ctx) -> {
            DummyNode.DummyRootNode node = DummyTreeUtil.tree(() -> DummyTreeUtil.root(new DummyNode[0]));
            ctx.addViolationWithMessage((Node)node, unescapedMessage, args);
        });
        return (RuleViolation)report.getViolations().get(0);
    }
}

