/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.function.Consumer;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.XMLRenderer;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ParametricRuleViolation;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ReportTest {
    ReportTest() {
    }

    @Test
    void testSortedReportFile() {
        XMLRenderer rend = new XMLRenderer();
        String result = ReportTest.render((Renderer)rend, r -> {
            FileLocation s = ReportTest.getNode(10, 5, "foo");
            MockRule rule1 = new MockRule("name", "desc", "msg", "rulesetname");
            r.onRuleViolation(ReportTest.violation((Rule)rule1, s));
            FileLocation s1 = ReportTest.getNode(10, 5, "bar");
            MockRule rule2 = new MockRule("name", "desc", "msg", "rulesetname");
            r.onRuleViolation(ReportTest.violation((Rule)rule2, s1));
        });
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"bar"));
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.containsString((String)"foo"));
        Assertions.assertTrue((result.indexOf("bar") < result.indexOf("foo") ? 1 : 0) != 0, (String)"sort order wrong");
    }

    @Test
    void testSortedReportLine() {
        XMLRenderer rend = new XMLRenderer();
        String result = ReportTest.render((Renderer)rend, r -> {
            FileLocation node1 = ReportTest.getNode(20, 5, "foo1");
            MockRule rule1 = new MockRule("rule1", "rule1", "msg", "rulesetname");
            r.onRuleViolation(ReportTest.violation((Rule)rule1, node1));
            FileLocation node2 = ReportTest.getNode(10, 5, "foo1");
            MockRule rule2 = new MockRule("rule2", "rule2", "msg", "rulesetname");
            r.onRuleViolation(ReportTest.violation((Rule)rule2, node2));
        });
        Assertions.assertTrue((result.indexOf("rule2") < result.indexOf("rule1") ? 1 : 0) != 0, (String)"sort order wrong");
    }

    @Test
    void testIterator() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        FileLocation loc1 = ReportTest.getNode(5, 5, "file1");
        FileLocation loc2 = ReportTest.getNode(5, 6, "file1");
        Report r = Report.buildReport(arg_0 -> ReportTest.lambda$testIterator$2((Rule)rule, loc1, loc2, arg_0));
        Assertions.assertEquals((int)2, (int)r.getViolations().size());
    }

    @Test
    void testFilterViolations() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        FileLocation loc1 = ReportTest.getNode(5, 5, "file1");
        FileLocation loc2 = ReportTest.getNode(5, 6, "file1");
        Report r = Report.buildReport(arg_0 -> ReportTest.lambda$testFilterViolations$3((Rule)rule, loc1, loc2, arg_0));
        Report filtered = r.filterViolations(ruleViolation -> !"to be filtered".equals(ruleViolation.getDescription()));
        Assertions.assertEquals((int)1, (int)filtered.getViolations().size());
        Assertions.assertEquals((Object)"msg", (Object)((RuleViolation)filtered.getViolations().get(0)).getDescription());
    }

    @Test
    void testUnion() {
        MockRule rule = new MockRule("name", "desc", "msg", "rulesetname");
        FileLocation loc1 = ReportTest.getNode(1, 2, "file1");
        Report report1 = Report.buildReport(arg_0 -> ReportTest.lambda$testUnion$5((Rule)rule, loc1, arg_0));
        FileLocation loc2 = ReportTest.getNode(2, 1, "file1");
        Report report2 = Report.buildReport(arg_0 -> ReportTest.lambda$testUnion$6((Rule)rule, loc2, arg_0));
        Report union = report1.union(report2);
        Assertions.assertEquals((int)2, (int)union.getViolations().size());
    }

    public static @NonNull RuleViolation violation(Rule rule, FileLocation loc2) {
        return ReportTest.violation(rule, loc2, rule.getMessage());
    }

    public static @NonNull RuleViolation violation(Rule rule, FileLocation loc1, String rule1) {
        return new ParametricRuleViolation(rule, loc1, rule1, Collections.emptyMap());
    }

    private static FileLocation getNode(int line, int column, String filename) {
        return FileLocation.caret((FileId)FileId.fromPathLikeString((String)filename), (int)line, (int)column);
    }

    public static String render(Renderer renderer, Consumer<? super FileAnalysisListener> listenerEffects) {
        return ReportTest.renderGlobal(renderer, globalListener -> {
            LanguageVersion dummyVersion = DummyLanguageModule.getInstance().getDefaultVersion();
            TextFile dummyFile = TextFile.forCharSeq((CharSequence)"dummyText", (FileId)FileId.fromPathLikeString((String)"file"), (LanguageVersion)dummyVersion);
            try (FileAnalysisListener fal = globalListener.startFileAnalysis(dummyFile);){
                listenerEffects.accept(fal);
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        });
    }

    public static String renderGlobal(Renderer renderer, Consumer<? super GlobalAnalysisListener> listenerEffects) {
        StringWriter writer = new StringWriter();
        renderer.setWriter((Writer)writer);
        try (GlobalAnalysisListener listener = renderer.newListener();){
            listenerEffects.accept((GlobalAnalysisListener)listener);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        return writer.toString();
    }

    private static /* synthetic */ void lambda$testUnion$6(Rule rule, FileLocation loc2, FileAnalysisListener it) {
        it.onRuleViolation(ReportTest.violation(rule, loc2));
    }

    private static /* synthetic */ void lambda$testUnion$5(Rule rule, FileLocation loc1, FileAnalysisListener it) {
        it.onRuleViolation(ReportTest.violation(rule, loc1));
    }

    private static /* synthetic */ void lambda$testFilterViolations$3(Rule rule, FileLocation loc1, FileLocation loc2, FileAnalysisListener it) {
        it.onRuleViolation(ReportTest.violation(rule, loc1));
        it.onRuleViolation(ReportTest.violation(rule, loc2, "to be filtered"));
    }

    private static /* synthetic */ void lambda$testIterator$2(Rule rule, FileLocation loc1, FileLocation loc2, FileAnalysisListener it) {
        it.onRuleViolation(ReportTest.violation(rule, loc1));
        it.onRuleViolation(ReportTest.violation(rule, loc2));
    }
}

