/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.reporting.ConfigurableFileNameRenderer;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConfigurableFileNameRendererTest {
    ConfigurableFileNameRendererTest() {
    }

    @Test
    void testRelativize() {
        FileId file = FileId.fromPath((Path)Paths.get("a", "b", "c"));
        String displayName = ConfigurableFileNameRenderer.getDisplayName((FileId)file, (List)CollectionUtil.listOf((Object)Paths.get("a", new String[0]), (Object[])new Path[0]));
        Assertions.assertEquals((Object)displayName, (Object)Paths.get("b", "c").toString());
    }

    @Test
    void testRelativizeOutOfDir() {
        FileId file = FileId.fromPath((Path)Paths.get("a", "b", "c"));
        String displayName = ConfigurableFileNameRenderer.getDisplayName((FileId)file, (List)CollectionUtil.listOf((Object)Paths.get("d", new String[0]), (Object[])new Path[0]));
        Assertions.assertEquals((Object)displayName, (Object)Paths.get("..", "a", "b", "c").toString());
    }

    @Test
    void testRelativizeWithRoot() {
        Path path = Paths.get("a", "b", "c");
        FileId file = FileId.fromPath((Path)path);
        String displayName = ConfigurableFileNameRenderer.getDisplayName((FileId)file, (List)CollectionUtil.listOf((Object)Paths.get("/", new String[0]), (Object[])new Path[0]));
        Assertions.assertEquals((Object)path.toAbsolutePath().toString(), (Object)displayName);
    }
}

