/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.YAHTMLRenderer;
import net.sourceforge.pmd.reporting.InternalApiBridge;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.CollectionUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class YAHTMLRendererTest
extends AbstractRendererTest {
    private File outputDir;
    @TempDir
    private Path folder;

    YAHTMLRendererTest() {
    }

    @BeforeEach
    void setUp() {
        this.outputDir = this.folder.resolve("pmdtest").toFile();
        Assertions.assertTrue((boolean)this.outputDir.mkdir());
    }

    private RuleViolation newRuleViolation(int beginLine, int beginColumn, int endLine, int endColumn, String packageNameArg, String classNameArg) {
        FileLocation loc = this.createLocation(beginLine, beginColumn, endLine, endColumn);
        Map additionalInfo = CollectionUtil.mapOf((Object)"packageName", (Object)packageNameArg, (Object)"className", (Object)classNameArg);
        return InternalApiBridge.createRuleViolation((Rule)new FooRule(), (FileLocation)loc, (String)"blah", (Map)additionalInfo);
    }

    @Override
    protected RuleViolation newRuleViolation(int beginLine, int beginColumn, int endLine, int endColumn, Rule rule) {
        return this.newRuleViolation(beginLine, beginColumn, endLine, endColumn, "net.sf.pmd.test", "YAHTMLSampleClass");
    }

    @Test
    void testReportMultipleViolations() throws Exception {
        String actual = this.renderReport(this.getRenderer(), it -> {
            it.onRuleViolation(this.newRuleViolation(1, 1, 1, 1, "net.sf.pmd.test", "YAHTMLSampleClass1"));
            it.onRuleViolation(this.newRuleViolation(1, 1, 1, 2, "net.sf.pmd.test", "YAHTMLSampleClass1"));
            it.onRuleViolation(this.newRuleViolation(1, 1, 1, 1, "net.sf.pmd.other", "YAHTMLSampleClass2"));
        });
        Assertions.assertEquals((Object)this.filter(this.getExpected()), (Object)this.filter(actual));
        Object[] htmlFiles = this.outputDir.list();
        Assertions.assertEquals((int)3, (int)htmlFiles.length);
        Arrays.sort(htmlFiles);
        Assertions.assertEquals((Object)"YAHTMLSampleClass1.html", (Object)htmlFiles[0]);
        Assertions.assertEquals((Object)"YAHTMLSampleClass2.html", (Object)htmlFiles[1]);
        Assertions.assertEquals((Object)"index.html", (Object)htmlFiles[2]);
        for (Object file : htmlFiles) {
            try (FileInputStream in = new FileInputStream(new File(this.outputDir, (String)file));
                 InputStream expectedIn = YAHTMLRendererTest.class.getResourceAsStream("yahtml/" + (String)file);){
                String data = IOUtil.readToString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                String expected = YAHTMLRendererTest.normalizeLineSeparators(IOUtil.readToString((InputStream)expectedIn, (Charset)StandardCharsets.UTF_8));
                Assertions.assertEquals((Object)expected, (Object)data, (String)("File " + (String)file + " is different"));
            }
        }
    }

    private static String normalizeLineSeparators(String s) {
        return s.replaceAll("\\R", System.lineSeparator());
    }

    @Override
    Renderer getRenderer() {
        YAHTMLRenderer result = new YAHTMLRenderer();
        result.setProperty(YAHTMLRenderer.OUTPUT_DIR, (Object)this.outputDir.getAbsolutePath());
        return result;
    }

    @Override
    String getExpected() {
        return "<h3 align=\"center\">The HTML files are located in '" + this.outputDir + "'.</h3>" + System.lineSeparator();
    }

    @Override
    String getExpectedEmpty() {
        return this.getExpected();
    }

    @Override
    String getExpectedMultiple() {
        return this.getExpected();
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        return this.getExpected();
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return this.getExpected();
    }
}

