/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.TextRange2d;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.XSLTRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class XSLTRendererTest
extends AbstractRendererTest {
    XSLTRendererTest() {
    }

    @Override
    Renderer getRenderer() {
        return new XSLTRenderer();
    }

    @Override
    String getExpected() {
        return this.readFile("expected.html");
    }

    @Override
    String getExpectedEmpty() {
        return this.readFile("empty.html");
    }

    @Override
    String getExpectedMultiple() {
        return this.readFile("expected-multiple.html");
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        return this.readFile("expected-error.html");
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return this.readFile("expected-error.html");
    }

    @Override
    String filter(String expected) {
        return expected.replaceAll("<h2>PMD " + PMDVersion.VERSION + " Report\\. Generated on .+</h2>", "<h2>PMD unknown Report. Generated on ...</h2>").replaceAll("<title>PMD " + PMDVersion.VERSION + " Report</title>", "<title>PMD unknown Report</title>").replaceAll("\r\n", "\n");
    }

    @Test
    void testDefaultStylesheet() throws Exception {
        XSLTRenderer renderer = new XSLTRenderer();
        FileLocation loc = FileLocation.range((FileId)FileId.UNKNOWN, (TextRange2d)TextRange2d.range2d((int)1, (int)1, (int)1, (int)2));
        RuleViolation rv = this.newRuleViolation((Rule)new FooRule(), loc, "violation message");
        String result = this.renderReport((Renderer)renderer, it -> it.onRuleViolation(rv));
        Assertions.assertTrue((boolean)result.contains("violation message"));
    }

    @Override
    protected String readFile(String relativePath) {
        return super.readFile("xslt/" + relativePath);
    }
}

