/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.renderers.TextRenderer;
import net.sourceforge.pmd.reporting.Report;

class TextRendererTest
extends AbstractRendererTest {
    TextRendererTest() {
    }

    @Override
    Renderer getRenderer() {
        return new TextRenderer();
    }

    @Override
    String getExpected() {
        return this.getSourceCodeFilename() + ":1:\tFoo:\tblah" + EOL;
    }

    @Override
    String getExpectedEmpty() {
        return "";
    }

    @Override
    String getExpectedMultiple() {
        return this.getSourceCodeFilename() + ":1:\tFoo:\tblah" + EOL + this.getSourceCodeFilename() + ":1:\tBoo:\tblah" + EOL;
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        return "file\t-\tRuntimeException: Error" + EOL;
    }

    @Override
    String getExpectedErrorWithoutMessage(Report.ProcessingError error) {
        return "file\t-\tNullPointerException: null" + EOL;
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return "Foo\t-\ta configuration error" + EOL;
    }
}

