/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import net.sourceforge.pmd.FooRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.JsonRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonRendererTest
extends AbstractRendererTest {
    JsonRendererTest() {
    }

    @Override
    Renderer getRenderer() {
        return new JsonRenderer();
    }

    @Override
    String getExpected() {
        return this.readFile("expected.json");
    }

    @Override
    String getExpectedEmpty() {
        return this.readFile("empty.json");
    }

    @Override
    String getExpectedMultiple() {
        return this.readFile("expected-multiple.json");
    }

    @Override
    String getExpectedError(Report.ProcessingError error) {
        String expected = this.readFile("expected-processingerror.json");
        expected = expected.replace("###REPLACE_ME###", error.getDetail().replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t"));
        return expected;
    }

    @Override
    String getExpectedError(Report.ConfigurationError error) {
        return this.readFile("expected-configurationerror.json");
    }

    @Override
    String getExpectedErrorWithoutMessage(Report.ProcessingError error) {
        String expected = this.readFile("expected-processingerror-no-message.json");
        expected = expected.replace("###REPLACE_ME###", error.getDetail().replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n").replaceAll("\t", "\\\\t"));
        return expected;
    }

    @Override
    protected String readFile(String relativePath) {
        return super.readFile("json/" + relativePath);
    }

    @Override
    String filter(String expected) {
        return expected.replaceAll("\"timestamp\":\\s*\"[^\"]+\"", "\"timestamp\": \"--replaced--\"").replaceAll("\"pmdVersion\":\\s*\"[^\"]+\"", "\"pmdVersion\": \"unknown\"").replaceAll("\\R", "\n");
    }

    @Test
    void suppressedViolations() throws IOException {
        Report.SuppressedViolation suppressed = new Report.SuppressedViolation(this.newRuleViolation(1, 1, 1, 1, (Rule)new FooRule()), ViolationSuppressor.NOPMD_COMMENT_SUPPRESSOR, "test");
        String actual = this.renderReport(this.getRenderer(), it -> it.onSuppressedRuleViolation(suppressed));
        String expected = this.readFile("expected-suppressed.json");
        Assertions.assertEquals((Object)this.filter(expected), (Object)this.filter(actual));
    }
}

