/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import net.sourceforge.pmd.PMDVersion;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.renderers.AbstractRendererTest;
import net.sourceforge.pmd.renderers.CodeClimateRenderer;
import net.sourceforge.pmd.renderers.Renderer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CodeClimateRendererTest
extends AbstractRendererTest {
    private static final String VERSION_PART = PMDVersion.isUnknown() || PMDVersion.isSnapshot() ? "latest" : "pmd-doc-" + PMDVersion.VERSION;

    CodeClimateRendererTest() {
    }

    @Override
    Renderer getRenderer() {
        return new CodeClimateRenderer();
    }

    @Override
    String getExpected() {
        return "{\"type\":\"issue\",\"check_name\":\"Foo\",\"description\":\"blah\",\"content\":{\"body\":\"## Foo\\n\\nSince: PMD null\\n\\nPriority: Low\\n\\n[Categories](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#categories): Style\\n\\n[Remediation Points](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#remediation-points): 50000\\n\\nDescription with Unicode Character U+2013: \u2013 .\\n\\n### [PMD properties](https://docs.pmd-code.org/" + VERSION_PART + "/pmd_userdocs_configuring_rules.html#rule-properties)\\n\\nName | Value | Description\\n--- | --- | ---\\nviolationSuppressRegex | | Suppress violations with messages matching a regular expression\\nviolationSuppressXPath | | Suppress violations on nodes which match a given relative XPath expression.\\n\"},\"categories\":[\"Style\"],\"location\":{\"path\":\"" + this.getSourceCodeFilename() + "\",\"lines\":{\"begin\":1,\"end\":1}},\"severity\":\"info\",\"remediation_points\":50000}\u0000" + EOL;
    }

    @Override
    String getExpectedWithProperties() {
        return "{\"type\":\"issue\",\"check_name\":\"Foo\",\"description\":\"blah\",\"content\":{\"body\":\"## Foo\\n\\nSince: PMD null\\n\\nPriority: Low\\n\\n[Categories](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#categories): Style\\n\\n[Remediation Points](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#remediation-points): 50000\\n\\nDescription with Unicode Character U+2013: \u2013 .\\n\\n### [PMD properties](https://docs.pmd-code.org/" + VERSION_PART + "/pmd_userdocs_configuring_rules.html#rule-properties)\\n\\nName | Value | Description\\n--- | --- | ---\\nviolationSuppressRegex | | Suppress violations with messages matching a regular expression\\nviolationSuppressXPath | | Suppress violations on nodes which match a given relative XPath expression.\\nstringProperty | the string value\\nsecond line with 'quotes' | simple string property\\nmultiString | default1,default2 | multi string property\\n\"},\"categories\":[\"Style\"],\"location\":{\"path\":\"" + this.getSourceCodeFilename() + "\",\"lines\":{\"begin\":1,\"end\":1}},\"severity\":\"info\",\"remediation_points\":50000}\u0000" + EOL;
    }

    @Override
    String getExpectedEmpty() {
        return "";
    }

    @Override
    String getExpectedMultiple() {
        return "{\"type\":\"issue\",\"check_name\":\"Foo\",\"description\":\"blah\",\"content\":{\"body\":\"## Foo\\n\\nSince: PMD null\\n\\nPriority: Low\\n\\n[Categories](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#categories): Style\\n\\n[Remediation Points](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#remediation-points): 50000\\n\\nDescription with Unicode Character U+2013: \u2013 .\\n\\n### [PMD properties](https://docs.pmd-code.org/" + VERSION_PART + "/pmd_userdocs_configuring_rules.html#rule-properties)\\n\\nName | Value | Description\\n--- | --- | ---\\nviolationSuppressRegex | | Suppress violations with messages matching a regular expression\\nviolationSuppressXPath | | Suppress violations on nodes which match a given relative XPath expression.\\n\"},\"categories\":[\"Style\"],\"location\":{\"path\":\"" + this.getSourceCodeFilename() + "\",\"lines\":{\"begin\":1,\"end\":1}},\"severity\":\"info\",\"remediation_points\":50000}\u0000" + EOL + "{\"type\":\"issue\",\"check_name\":\"Boo\",\"description\":\"blah\",\"content\":{\"body\":\"## Boo\\n\\nSince: PMD null\\n\\nPriority: High\\n\\n[Categories](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#categories): Style\\n\\n[Remediation Points](https://github.com/codeclimate/platform/blob/master/spec/analyzers/SPEC.md#remediation-points): 50000\\n\\ndesc\\n\\n### [PMD properties](https://docs.pmd-code.org/" + VERSION_PART + "/pmd_userdocs_configuring_rules.html#rule-properties)\\n\\nName | Value | Description\\n--- | --- | ---\\nviolationSuppressRegex | | Suppress violations with messages matching a regular expression\\nviolationSuppressXPath | | Suppress violations on nodes which match a given relative XPath expression.\\n\"},\"categories\":[\"Style\"],\"location\":{\"path\":\"" + this.getSourceCodeFilename() + "\",\"lines\":{\"begin\":1,\"end\":1}},\"severity\":\"blocker\",\"remediation_points\":50000}\u0000" + EOL;
    }

    @Test
    void testXPathRule() throws Exception {
        FileLocation node = this.createLocation(1, 1, 1, 1);
        XPathRule theRule = new XPathRule(XPathVersion.XPATH_3_1, "//dummyNode");
        theRule.setDescription("Description with Unicode Character U+2013: \u2013 .");
        theRule.setName("Foo");
        String rendered = this.renderReport(this.getRenderer(), it -> it.onRuleViolation(this.newRuleViolation((Rule)theRule, node, "blah")));
        Assertions.assertEquals((Object)this.filter(this.getExpected()), (Object)this.filter(rendered));
    }
}

