/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sourceforge.pmd.properties.ConstraintViolatedException;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.properties.internal.PropertyParsingUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.SubstringMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PropertyDescriptorTest {
    private static final Map<String, SampleEnum> NAME_MAP = new LinkedHashMap<String, SampleEnum>();

    PropertyDescriptorTest() {
    }

    @Test
    void testDefaultValueConstraintViolationCausesFailure() {
        PropertyConstraint constraint = NumericConstraints.inRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(10));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(ConstraintViolatedException.class, () -> ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"fooProp").desc("hello")).defaultValue((Object)1000)).require(constraint)).build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), PropertyDescriptorTest.containsIgnoreCase(constraint.getConstraintDescription()));
    }

    @Test
    void testDefaultValueConstraintViolationCausesFailureMulti() {
        PropertyConstraint constraint = NumericConstraints.inRange((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(10.0));
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(ConstraintViolatedException.class, () -> ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.doubleListProperty((String)"fooProp").desc("hello")).defaultValues((Object)2.0, (Object[])new Double[]{11.0}).requireEach(constraint).build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), PropertyDescriptorTest.containsIgnoreCase(constraint.getConstraintDescription()));
    }

    @Test
    void testNoConstraintViolationCausesIsOkMulti() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.doubleListProperty((String)"fooProp").desc("hello")).defaultValues((Object)2.0, (Object[])new Double[]{11.0}).requireEach(NumericConstraints.inRange((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(20.0))).build();
        Assertions.assertEquals((Object)"fooProp", (Object)descriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)descriptor.description());
        MatcherAssert.assertThat((Object)((List)descriptor.defaultValue()), (Matcher)Matchers.contains((Object[])new Double[]{2.0, 11.0}));
    }

    @Test
    void testNoConstraintViolationCausesIsOk() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"fooProp").desc("hello")).defaultValue((Object)"bazooli")).build();
        Assertions.assertEquals((Object)"fooProp", (Object)descriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)descriptor.description());
        Assertions.assertEquals((Object)"bazooli", (Object)descriptor.defaultValue());
    }

    @Test
    void testIntProperty() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"intProp").desc("hello")).defaultValue((Object)1)).build();
        Assertions.assertEquals((Object)"intProp", (Object)descriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)descriptor.description());
        Assertions.assertEquals((Integer)1, (Integer)((Integer)descriptor.defaultValue()));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)descriptor.serializer().fromString("5")));
        Assertions.assertEquals((Integer)5, (Integer)((Integer)descriptor.serializer().fromString(" 5 ")));
        PropertyDescriptor listDescriptor = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.intListProperty((String)"intListProp").desc("hello")).defaultValues((Object)1, (Object[])new Integer[]{2}).build();
        Assertions.assertEquals((Object)"intListProp", (Object)listDescriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)listDescriptor.description());
        Assertions.assertEquals(Arrays.asList(1, 2), (Object)listDescriptor.defaultValue());
        Assertions.assertEquals(Arrays.asList(5, 7), (Object)listDescriptor.serializer().fromString("5,7"));
        Assertions.assertEquals(Arrays.asList(5, 7), (Object)listDescriptor.serializer().fromString(" 5 , 7 "));
    }

    @Test
    void testIntPropertyInvalidValue() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"intProp").desc("hello")).defaultValue((Object)1)).build();
        NumberFormatException thrown = (NumberFormatException)Assertions.assertThrows(NumberFormatException.class, () -> descriptor.serializer().fromString("not a number"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"not a number"));
    }

    @Test
    void testDoubleProperty() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.doubleProperty((String)"doubleProp").desc("hello")).defaultValue((Object)1.0)).build();
        Assertions.assertEquals((Object)"doubleProp", (Object)descriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)descriptor.description());
        Assertions.assertEquals((Double)1.0, (Double)((Double)descriptor.defaultValue()));
        Assertions.assertEquals((Double)2.0, (Double)((Double)descriptor.serializer().fromString("2.0")));
        Assertions.assertEquals((Double)2.0, (Double)((Double)descriptor.serializer().fromString("  2.0  ")));
        PropertyDescriptor listDescriptor = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.doubleListProperty((String)"doubleListProp").desc("hello")).defaultValues((Object)1.0, (Object[])new Double[]{2.0}).build();
        Assertions.assertEquals((Object)"doubleListProp", (Object)listDescriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)listDescriptor.description());
        Assertions.assertEquals(Arrays.asList(1.0, 2.0), (Object)listDescriptor.defaultValue());
        Assertions.assertEquals(Arrays.asList(2.0, 3.0), (Object)listDescriptor.serializer().fromString("2.0,3.0"));
        Assertions.assertEquals(Arrays.asList(2.0, 3.0), (Object)listDescriptor.serializer().fromString(" 2.0 , 3.0 "));
    }

    @Test
    void testDoublePropertyInvalidValue() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.doubleProperty((String)"doubleProp").desc("hello")).defaultValue((Object)1.0)).build();
        NumberFormatException thrown = (NumberFormatException)Assertions.assertThrows(NumberFormatException.class, () -> descriptor.serializer().fromString("this is not a number"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"this is not a number"));
    }

    @Test
    void testStringProperty() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"stringProp").desc("hello")).defaultValue((Object)"default value")).build();
        Assertions.assertEquals((Object)"stringProp", (Object)descriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)descriptor.description());
        Assertions.assertEquals((Object)"default value", (Object)descriptor.defaultValue());
        Assertions.assertEquals((Object)"foo", (Object)descriptor.serializer().fromString("foo"));
        Assertions.assertEquals((Object)"foo", (Object)descriptor.serializer().fromString("  foo   "));
    }

    @Test
    void testStringListProperty() {
        PropertyDescriptor listDescriptor = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"stringListProp").desc("hello")).defaultValues((Object)"v1", (Object[])new String[]{"v2"}).build();
        Assertions.assertEquals((Object)"stringListProp", (Object)listDescriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)listDescriptor.description());
        Assertions.assertEquals(Arrays.asList("v1", "v2"), (Object)listDescriptor.defaultValue());
        Assertions.assertEquals(Arrays.asList("foo", "bar"), (Object)listDescriptor.serializer().fromString("foo,bar"));
        Assertions.assertEquals(Arrays.asList("foo", "bar"), (Object)listDescriptor.serializer().fromString("  foo ,  bar  "));
    }

    @Test
    void testEnumProperty() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"enumProp", NAME_MAP).desc("hello")).defaultValue((Object)SampleEnum.B)).build();
        Assertions.assertEquals((Object)"enumProp", (Object)descriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)descriptor.description());
        Assertions.assertEquals((Object)((Object)SampleEnum.B), (Object)descriptor.defaultValue());
        Assertions.assertEquals((Object)((Object)SampleEnum.C), (Object)descriptor.serializer().fromString("TEST_C"));
        PropertyDescriptor listDescriptor = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)"enumListProp", NAME_MAP).desc("hello")).defaultValues((Object)SampleEnum.A, (Object[])new SampleEnum[]{SampleEnum.B}).build();
        Assertions.assertEquals((Object)"enumListProp", (Object)listDescriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)listDescriptor.description());
        Assertions.assertEquals(Arrays.asList(SampleEnum.A, SampleEnum.B), (Object)listDescriptor.defaultValue());
        Assertions.assertEquals(Arrays.asList(SampleEnum.B, SampleEnum.C), (Object)listDescriptor.serializer().fromString("TEST_B,TEST_C"));
    }

    @Test
    void testEnumPropertyNullValueFailsBuild() {
        HashMap<String, SampleEnum> map = new HashMap<String, SampleEnum>(NAME_MAP);
        map.put("TEST_NULL", null);
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyFactory.enumProperty((String)"enumProp", (Map)map));
        MatcherAssert.assertThat((Object)thrown.getMessage(), PropertyDescriptorTest.containsIgnoreCase("null value"));
    }

    @Test
    void testEnumListPropertyNullValueFailsBuild() {
        HashMap<String, SampleEnum> map = new HashMap<String, SampleEnum>(NAME_MAP);
        map.put("TEST_NULL", null);
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyFactory.enumListProperty((String)"enumProp", (Map)map));
        MatcherAssert.assertThat((Object)thrown.getMessage(), PropertyDescriptorTest.containsIgnoreCase("null value"));
    }

    @Test
    void testEnumPropertyInvalidValue() {
        PropertyDescriptor descriptor = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"enumProp", NAME_MAP).desc("hello")).defaultValue((Object)SampleEnum.B)).build();
        IllegalArgumentException thrown = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> descriptor.serializer().fromString("InvalidEnumValue"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"'InvalidEnumValue' should be one of 'TEST_A', 'TEST_B', 'TEST_C'"));
    }

    @Test
    void testRegexProperty() {
        PropertyDescriptor descriptor = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"regexProp").desc("hello")).defaultValue("^[A-Z].*$").build();
        Assertions.assertEquals((Object)"regexProp", (Object)descriptor.name());
        Assertions.assertEquals((Object)"hello", (Object)descriptor.description());
        Assertions.assertEquals((Object)"^[A-Z].*$", (Object)((Pattern)descriptor.defaultValue()).toString());
        Assertions.assertEquals((Object)"[0-9]+", (Object)((Pattern)descriptor.serializer().fromString("[0-9]+")).toString());
    }

    @Test
    void testRegexPropertyInvalidValue() {
        PropertyDescriptor descriptor = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"regexProp").desc("hello")).defaultValue("^[A-Z].*$").build();
        PatternSyntaxException thrown = (PatternSyntaxException)Assertions.assertThrows(PatternSyntaxException.class, () -> descriptor.serializer().fromString("[open class"));
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Unclosed character class"));
    }

    @Test
    void testRegexPropertyInvalidDefaultValue() {
        PatternSyntaxException thrown = (PatternSyntaxException)Assertions.assertThrows(PatternSyntaxException.class, () -> ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"regexProp").desc("hello")).defaultValue("[open class").build());
        MatcherAssert.assertThat((Object)thrown.getMessage(), (Matcher)Matchers.containsString((String)"Unclosed character class"));
    }

    private static List<String> parseEscaped(String s, char d) {
        return PropertyParsingUtil.parseListWithEscapes((String)s, (char)d, Function.identity());
    }

    @Test
    void testStringParserEmptyString() {
        Assertions.assertEquals(Collections.emptyList(), PropertyDescriptorTest.parseEscaped("", ','));
    }

    @Test
    void testStringParserSimple() {
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"a", (Object[])new String[]{"b", "c"}), PropertyDescriptorTest.parseEscaped("a,b,c", ','));
    }

    @Test
    void testStringParserEscapedChar() {
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"a", (Object[])new String[]{"b,c"}), PropertyDescriptorTest.parseEscaped("a,b\\,c", ','));
    }

    @Test
    void testStringParserEscapedEscapedChar() {
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"a", (Object[])new String[]{"b\\", "c"}), PropertyDescriptorTest.parseEscaped("a,b\\\\,c", ','));
    }

    @Test
    void testStringParserDelimIsBackslash() {
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"a,b", (Object[])new String[]{"", ",c"}), PropertyDescriptorTest.parseEscaped("a,b\\\\,c", '\\'));
    }

    @Test
    void testStringParserTrailingBackslash() {
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"a", (Object[])new String[]{"b\\"}), PropertyDescriptorTest.parseEscaped("a,b\\", ','));
    }

    private static Matcher<String> containsIgnoreCase(String substring) {
        return new SubstringMatcher("containing (ignoring case)", true, substring){

            protected boolean evalSubstringOf(String string) {
                return StringUtils.indexOfIgnoreCase((CharSequence)string, (CharSequence)this.substring) != -1;
            }
        };
    }

    static {
        NAME_MAP.put("TEST_A", SampleEnum.A);
        NAME_MAP.put("TEST_B", SampleEnum.B);
        NAME_MAP.put("TEST_C", SampleEnum.C);
    }

    private static enum SampleEnum {
        A,
        B,
        C;

    }
}

