/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.properties.ConstraintViolatedException;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyConstraint;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NumericConstraintsTest {
    NumericConstraintsTest() {
    }

    @Test
    void testInRangeInteger() {
        PropertyConstraint constraint = NumericConstraints.inRange((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(10));
        Assertions.assertNull((Object)this.errorAsString(constraint, 1));
        Assertions.assertNull((Object)this.errorAsString(constraint, 5));
        Assertions.assertNull((Object)this.errorAsString(constraint, 10));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 0));
        Assertions.assertEquals((Object)"'-1' should be between 1 and 10", (Object)this.errorAsString(constraint, -1));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 11));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 100));
    }

    private <T> @Nullable String errorAsString(PropertyConstraint<T> constraint, T value) {
        try {
            constraint.validate(value);
            return null;
        }
        catch (ConstraintViolatedException e) {
            return e.getMessage();
        }
    }

    @Test
    void testInRangeDouble() {
        PropertyConstraint constraint = NumericConstraints.inRange((Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(10.0));
        Assertions.assertNull((Object)this.errorAsString(constraint, 1.0));
        Assertions.assertNull((Object)this.errorAsString(constraint, 5.5));
        Assertions.assertNull((Object)this.errorAsString(constraint, 10.0));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 0.0));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, -1.0));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 11.1));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 100.0));
    }

    @Test
    void testPositive() {
        PropertyConstraint constraint = NumericConstraints.positive();
        Assertions.assertNull((Object)this.errorAsString(constraint, 1));
        Assertions.assertNull((Object)this.errorAsString(constraint, Float.valueOf(1.5f)));
        Assertions.assertNull((Object)this.errorAsString(constraint, 1.5));
        Assertions.assertNull((Object)this.errorAsString(constraint, 100));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 0));
        Assertions.assertEquals((Object)"'0.1' should be positive", (Object)this.errorAsString(constraint, Float.valueOf(0.1f)));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 0.9));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, -1));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, -100));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, Float.valueOf(-0.1f)));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, -0.1));
    }

    @Test
    void testBelow() {
        PropertyConstraint constraint = NumericConstraints.below((Comparable)Integer.valueOf(5));
        Assertions.assertNull((Object)this.errorAsString(constraint, 5));
        Assertions.assertNull((Object)this.errorAsString(constraint, 3));
        Assertions.assertNull((Object)this.errorAsString(constraint, 1));
        Assertions.assertNull((Object)this.errorAsString(constraint, 0));
        Assertions.assertNull((Object)this.errorAsString(constraint, -1));
        Assertions.assertEquals((Object)"'6' should be smaller or equal to 5", (Object)this.errorAsString(constraint, 6));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 10));
    }

    @Test
    void testAbove() {
        PropertyConstraint constraint = NumericConstraints.above((Comparable)Double.valueOf(2.5));
        Assertions.assertNull((Object)this.errorAsString(constraint, 2.5));
        Assertions.assertNull((Object)this.errorAsString(constraint, 3.0));
        Assertions.assertNull((Object)this.errorAsString(constraint, 3.5));
        Assertions.assertEquals((Object)"'2.0' should be greater or equal to 2.5", (Object)this.errorAsString(constraint, 2.0));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 1.5));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 1.0));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, 0.0));
        Assertions.assertNotNull((Object)this.errorAsString(constraint, -5.0));
    }
}

