/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import java.util.HashMap;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.DummyNodeWithListAndEnum;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.DummyTreeUtil;
import net.sourceforge.pmd.lang.rule.xpath.PmdXPathException;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionDefinition;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathHandler;
import net.sourceforge.pmd.lang.rule.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonXPathRuleQuery;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class SaxonXPathRuleQueryTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    SaxonXPathRuleQueryTest() {
    }

    @Test
    void testHigherOrderFuns() {
        DummyNode.DummyRootNode tree = this.helper.parse("(oha)");
        SaxonXPathRuleQueryTest.assertQuery(1, "//dummyRootNode[(@Image => substring-after('[') => substring-before(']')) ! . = '']", (Node)tree, new PropertyDescriptor[0]);
    }

    @Test
    void testListProperty() {
        DummyNodeWithListAndEnum dummy = new DummyNodeWithListAndEnum();
        PropertyDescriptor prop = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"prop").defaultValues((Object)"FOO", (Object[])new String[]{"BAR"}).desc("description")).build();
        SaxonXPathRuleQueryTest.assertQuery(1, "//dummyRootNode[@Enum = $prop]", (Node)dummy, prop);
    }

    @Test
    void testInvalidReturn() {
        DummyNodeWithListAndEnum dummy = new DummyNodeWithListAndEnum();
        PmdXPathException exception = (PmdXPathException)Assertions.assertThrows(PmdXPathException.class, () -> SaxonXPathRuleQueryTest.createQuery("1+2", new PropertyDescriptor[0]).evaluate((Node)dummy));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"XPath rule expression returned a non-node"));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.containsString((String)"Int64Value"));
    }

    @Test
    void testRootExpression() {
        DummyNode.DummyRootNode dummy = this.helper.parse("(oha)");
        List<Node> result = SaxonXPathRuleQueryTest.assertQuery(1, "/", (Node)dummy, new PropertyDescriptor[0]);
        Assertions.assertEquals((Object)((Object)dummy), (Object)result.get(0));
    }

    @Test
    void testRootExpressionIsADocumentNode() {
        DummyNode.DummyRootNode dummy = this.helper.parse("(oha)");
        List<Node> result = SaxonXPathRuleQueryTest.assertQuery(1, "(/)[self::document-node()]", (Node)dummy, new PropertyDescriptor[0]);
        Assertions.assertEquals((Object)((Object)dummy), (Object)result.get(0));
    }

    @Test
    void testRootExpressionWithName() {
        DummyNode.DummyRootNode dummy = this.helper.parse("(oha)");
        String xpathName = dummy.getXPathNodeName();
        List<Node> result = SaxonXPathRuleQueryTest.assertQuery(1, "(/)[self::document-node(element(" + xpathName + "))]", (Node)dummy, new PropertyDescriptor[0]);
        Assertions.assertEquals((Object)((Object)dummy), (Object)result.get(0));
        SaxonXPathRuleQueryTest.assertQuery(0, "(/)[self::document-node(element(DummyNodeX))]", (Node)dummy, new PropertyDescriptor[0]);
    }

    @Test
    void ruleChainVisits() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[@Image='baz']/foo | //bar[@Public = 'true'] | //dummyNode[@Public = false()] | //dummyNode", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)2, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertTrue((boolean)ruleChainVisits.contains("bar"));
        Assertions.assertEquals((int)3, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("(self::node()[(string(data(@Image))) eq \"baz\"])/child::element(foo)", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
        SaxonXPathRuleQueryTest.assertExpression("self::node()[(boolean(data(@Public))) eq false()]", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(1));
        SaxonXPathRuleQueryTest.assertExpression("self::node()", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(2));
        SaxonXPathRuleQueryTest.assertExpression("self::node()[(string(data(@Public))) eq \"true\"]", (Expression)query.getExpressionsForLocalNameOrDefault("bar").get(0));
        SaxonXPathRuleQueryTest.assertExpression("(((docOrder((((/)/descendant::element(dummyNode))[(string(data(@Image))) eq \"baz\"])/child::element(foo))) | (((/)/descendant::element(bar))[(string(data(@Public))) eq \"true\"])) | (((/)/descendant::element(dummyNode))[(boolean(data(@Public))) eq false()])) | ((/)/descendant::element(dummyNode))", query.getFallbackExpr());
    }

    @Test
    void ruleChainVisitsMultipleFilters() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[@Test1 = false()][@Test2 = true()]", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)1, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertEquals((int)2, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("(self::node()[(boolean(data(@Test1))) eq false()])[(boolean(data(@Test2))) eq true()]", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
        SaxonXPathRuleQueryTest.assertExpression("(((/)/descendant::element(dummyNode))[(boolean(data(@Test1))) eq false()])[(boolean(data(@Test2))) eq true()]", query.getFallbackExpr());
    }

    @Test
    void ruleChainVisitsCustomFunctions() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[pmd-dummy:imageIs(@Image)]", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)1, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertEquals((int)2, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("self::node()[Q{http://pmd.sourceforge.net/pmd-dummy}imageIs(exactly-one(convertUntyped(data(@Image))))]", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
        SaxonXPathRuleQueryTest.assertExpression("((/)/descendant::element(Q{}dummyNode))[Q{http://pmd.sourceforge.net/pmd-dummy}imageIs(exactly-one(convertUntyped(data(@Image))))]", query.getFallbackExpr());
    }

    @Test
    void ruleChainVisitsUnboundedPathExpressions() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[//ClassOrInterfaceType]", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)0, (int)ruleChainVisits.size());
        Assertions.assertEquals((int)1, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("let $Q{http://saxon.sf.net/generated-variable}v0 := (/)/descendant::element(Q{}ClassOrInterfaceType) return (((/)/descendant::element(Q{}dummyNode))[exists($Q{http://saxon.sf.net/generated-variable}v0)])", query.getFallbackExpr());
        query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[ancestor::ClassOrInterfaceDeclaration[//ClassOrInterfaceType]]", new PropertyDescriptor[0]);
        ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)0, (int)ruleChainVisits.size());
        Assertions.assertEquals((int)1, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("let $Q{http://saxon.sf.net/generated-variable}v0 := (/)/descendant::element(Q{}ClassOrInterfaceType) return (((/)/descendant::element(Q{}dummyNode))[exists(ancestor::element(Q{}ClassOrInterfaceDeclaration)[exists($Q{http://saxon.sf.net/generated-variable}v0)])])", query.getFallbackExpr());
        query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[//ClassOrInterfaceType or //OtherNode]", new PropertyDescriptor[0]);
        ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)0, (int)ruleChainVisits.size());
        Assertions.assertEquals((int)1, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("let $Q{http://saxon.sf.net/generated-variable}v0 := (exists((/)/descendant::element(Q{}ClassOrInterfaceType))) or (exists((/)/descendant::element(Q{}OtherNode))) return (((/)/descendant::element(Q{}dummyNode))[$Q{http://saxon.sf.net/generated-variable}v0])", query.getFallbackExpr());
    }

    @Test
    void ruleChainVisitsNested() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode/foo/*/bar[@Test = 'false']", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)1, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertEquals((int)2, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("(((self::node()/child::element(foo))/child::element())/child::element(bar))[(string(data(@Test))) eq \"false\"]", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
        SaxonXPathRuleQueryTest.assertExpression("docOrder(((docOrder((((/)/descendant::element(dummyNode))/child::element(foo))/child::element()))/child::element(bar))[(string(data(@Test))) eq \"false\"])", query.getFallbackExpr());
    }

    @Test
    void ruleChainVisitsNested2() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode/foo[@Baz = 'a']/*/bar[@Test = 'false']", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)1, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertEquals((int)2, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("((((self::node()/child::element(foo))[(string(data(@Baz))) eq \"a\"])/child::element())/child::element(bar))[(string(data(@Test))) eq \"false\"]", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
        SaxonXPathRuleQueryTest.assertExpression("docOrder(((docOrder(((((/)/descendant::element(dummyNode))/child::element(foo))[(string(data(@Baz))) eq \"a\"])/child::element()))/child::element(bar))[(string(data(@Test))) eq \"false\"])", query.getFallbackExpr());
    }

    @Test
    void unionBeforeSlash() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("(//dummyNode | //dummyNodeB)/dummyNode[@Image = '10']", new PropertyDescriptor[0]);
        DummyNode.DummyRootNode tree = DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.node(DummyTreeUtil.node(new DummyNode[0])), DummyTreeUtil.nodeB(DummyTreeUtil.node(new DummyNode[0]))));
        tree.descendantsOrSelf().forEach(n -> {
            List results = query.evaluate((Node)n);
            Assertions.assertEquals((int)1, (int)results.size());
            Assertions.assertEquals((Object)((Object)DummyTreeUtil.followPath(tree, "10")), results.get(0));
        });
        SaxonXPathRuleQueryTest.assertExpression("docOrder((((/)/descendant::(element(dummyNode) | element(dummyNodeB)))/child::element(dummyNode))[(string(data(@Image))) eq \"10\"])", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
    }

    @Test
    void unionBeforeSlashWithFilter() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("(//dummyNode[@Image='0'] | //dummyNodeB[@Image='1'])/dummyNode[@Image = '10']", new PropertyDescriptor[0]);
        DummyNode.DummyRootNode tree = DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.node(DummyTreeUtil.node(new DummyNode[0])), DummyTreeUtil.nodeB(DummyTreeUtil.node(new DummyNode[0]))));
        Assertions.assertEquals((int)0, (int)query.getRuleChainVisits().size());
        SaxonXPathRuleQueryTest.assertExpression("docOrder((((((/)/descendant::element(dummyNode))[(string(data(@Image))) eq \"0\"]) | (((/)/descendant::element(dummyNodeB))[(string(data(@Image))) eq \"1\"]))/child::element(dummyNode))[(string(data(@Image))) eq \"10\"])", query.getFallbackExpr());
        tree.descendantsOrSelf().forEach(n -> {
            List results = query.evaluate((Node)n);
            Assertions.assertEquals((int)1, (int)results.size());
            Assertions.assertEquals((Object)((Object)DummyTreeUtil.followPath(tree, "10")), results.get(0));
        });
    }

    @Test
    void unionBeforeSlashDeeper() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("(//dummyNode | //dummyNodeB)/dummyNode/dummyNode", new PropertyDescriptor[0]);
        DummyNode.DummyRootNode tree = DummyTreeUtil.tree(() -> DummyTreeUtil.root(DummyTreeUtil.node(DummyTreeUtil.node(DummyTreeUtil.node(new DummyNode[0]))), DummyTreeUtil.nodeB(DummyTreeUtil.node(new DummyNode[0]))));
        Assertions.assertEquals((int)0, (int)query.getRuleChainVisits().size());
        SaxonXPathRuleQueryTest.assertExpression("docOrder((((/)/descendant::(element(dummyNode) | element(dummyNodeB)))/child::element(dummyNode))/child::element(dummyNode))", query.getFallbackExpr());
        tree.descendantsOrSelf().forEach(n -> {
            List results = query.evaluate((Node)n);
            Assertions.assertEquals((int)1, (int)results.size());
            Assertions.assertEquals((Object)((Object)DummyTreeUtil.followPath(tree, "000")), results.get(0));
        });
    }

    @Test
    void ruleChainVisitWithVariable() {
        PropertyDescriptor testClassPattern = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"testClassPattern").desc("test")).defaultValue((Object)"a")).build();
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[matches(@SimpleName, $testClassPattern)]", testClassPattern);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)1, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertEquals((int)2, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("self::node()[matches(convertUntyped(data(@SimpleName)), \"a\", \"\")]", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
        SaxonXPathRuleQueryTest.assertExpression("((/)/descendant::element(Q{}dummyNode))[matches(convertUntyped(data(@SimpleName)), \"a\", \"\")]", query.getFallbackExpr());
    }

    @Test
    void ruleChainVisitWithVariable2() {
        PropertyDescriptor testClassPattern = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"testClassPattern").desc("test")).defaultValue((Object)"a")).build();
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[matches(@SimpleName, $testClassPattern)]/foo", testClassPattern);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)1, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertEquals((int)2, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("(self::node()[matches(convertUntyped(data(@SimpleName)), \"a\", \"\")])/child::element(Q{}foo)", (Expression)query.getExpressionsForLocalNameOrDefault("dummyNode").get(0));
        SaxonXPathRuleQueryTest.assertExpression("docOrder((((/)/descendant::element(Q{}dummyNode))[matches(convertUntyped(data(@SimpleName)), \"a\", \"\")])/child::element(Q{}foo))", query.getFallbackExpr());
    }

    @Test
    void ruleChainVisitWithTwoFunctions() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[ends-with(@Image, 'foo')][pmd-dummy:imageIs('bar')]", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)1, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertEquals((int)2, (int)query.nodeNameToXPaths.size());
        SaxonXPathRuleQueryTest.assertExpression("let $v0 := imageIs(\"bar\") return ((self::node()[ends-with(convertUntyped(data(@Image)), \"foo\")])[$v0])", (Expression)((List)query.nodeNameToXPaths.get("dummyNode")).get(0));
    }

    @Test
    void ruleChainWithUnions() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("(//ForStatement | //WhileStatement | //DoStatement)//AssignmentOperator", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)0, (int)ruleChainVisits.size());
    }

    @Test
    void ruleChainWithUnionsAndFilter() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("(//ForStatement | //WhileStatement | //DoStatement)//AssignmentOperator[@Image='foo']", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)0, (int)ruleChainVisits.size());
    }

    @Test
    void ruleChainWithUnionsCustomFunctionsVariant1() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("(//ForStatement | //WhileStatement | //DoStatement)//dummyNode[pmd-dummy:imageIs(@Image)]", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)0, (int)ruleChainVisits.size());
    }

    @Test
    void ruleChainWithUnionsCustomFunctionsVariant2() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//(ForStatement | WhileStatement | DoStatement)//dummyNode[pmd-dummy:imageIs(@Image)]", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)0, (int)ruleChainVisits.size());
    }

    @Test
    void ruleChainWithUnionsCustomFunctionsVariant3() {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//ForStatement//dummyNode[pmd-dummy:imageIs(@Image)] | //WhileStatement//dummyNode[pmd-dummy:imageIs(@Image)] | //DoStatement//dummyNode[pmd-dummy:imageIs(@Image)]", new PropertyDescriptor[0]);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)3, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("ForStatement"));
        Assertions.assertTrue((boolean)ruleChainVisits.contains("WhileStatement"));
        Assertions.assertTrue((boolean)ruleChainVisits.contains("DoStatement"));
        String expectedSubexpression = "(self::node()/descendant::element(dummyNode))[imageIs(exactly-one(convertUntyped(data(@Image))))]";
        SaxonXPathRuleQueryTest.assertExpression("(self::node()/descendant::element(dummyNode))[imageIs(exactly-one(convertUntyped(data(@Image))))]", (Expression)((List)query.nodeNameToXPaths.get("ForStatement")).get(0));
        SaxonXPathRuleQueryTest.assertExpression("(self::node()/descendant::element(dummyNode))[imageIs(exactly-one(convertUntyped(data(@Image))))]", (Expression)((List)query.nodeNameToXPaths.get("WhileStatement")).get(0));
        SaxonXPathRuleQueryTest.assertExpression("(self::node()/descendant::element(dummyNode))[imageIs(exactly-one(convertUntyped(data(@Image))))]", (Expression)((List)query.nodeNameToXPaths.get("DoStatement")).get(0));
    }

    @Test
    void ruleChainVisitsWithUnionsAndLets() {
        PropertyDescriptor boolProperty = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"checkAll").desc("test")).defaultValue((Object)true)).build();
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery("//dummyNode[$checkAll and ClassOrInterfaceType] | //ForStatement[not($checkAll)]", boolProperty);
        List ruleChainVisits = query.getRuleChainVisits();
        Assertions.assertEquals((int)2, (int)ruleChainVisits.size());
        Assertions.assertTrue((boolean)ruleChainVisits.contains("dummyNode"));
        Assertions.assertTrue((boolean)ruleChainVisits.contains("ForStatement"));
    }

    private static void assertExpression(String expected, Expression actual) {
        Assertions.assertEquals((Object)SaxonXPathRuleQueryTest.normalizeExprDump(expected), (Object)SaxonXPathRuleQueryTest.normalizeExprDump(actual.toString()));
    }

    private static String normalizeExprDump(String dump) {
        return dump.replaceAll("Q\\{[^}]*+}", "").replaceAll("\\$qq:qq-?\\d+", "\\$qq:qq000").replaceAll("\\$zz:zz-?\\d+", "\\$zz:zz000");
    }

    private static List<Node> assertQuery(int resultSize, String xpath, Node node, PropertyDescriptor<?> ... descriptors) {
        SaxonXPathRuleQuery query = SaxonXPathRuleQueryTest.createQuery(xpath, descriptors);
        List result = query.evaluate(node);
        Assertions.assertEquals((int)resultSize, (int)result.size(), (String)"Wrong number of matched nodes");
        return result;
    }

    private static SaxonXPathRuleQuery createQuery(String xpath, PropertyDescriptor<?> ... descriptors) {
        HashMap props = new HashMap();
        if (descriptors != null) {
            for (PropertyDescriptor<?> prop : descriptors) {
                props.put(prop, prop.defaultValue());
            }
        }
        return new SaxonXPathRuleQuery(xpath, XPathVersion.DEFAULT, props, XPathHandler.getHandlerForFunctionDefs((XPathFunctionDefinition)SaxonXPathRuleQueryTest.imageIsFunction(), (XPathFunctionDefinition[])new XPathFunctionDefinition[0]), (DeprecatedAttrLogger)DeprecatedAttrLogger.noop());
    }

    private static @NonNull XPathFunctionDefinition imageIsFunction() {
        return new XPathFunctionDefinition("imageIs", (Language)DummyLanguageModule.getInstance()){

            public XPathFunctionDefinition.Type[] getArgumentTypes() {
                return new XPathFunctionDefinition.Type[]{XPathFunctionDefinition.Type.SINGLE_STRING};
            }

            public XPathFunctionDefinition.Type getResultType() {
                return XPathFunctionDefinition.Type.SINGLE_BOOLEAN;
            }

            public XPathFunctionDefinition.FunctionCall makeCallExpression() {
                return (contextNode, arguments) -> StringUtils.equals((CharSequence)arguments[0].toString(), (CharSequence)contextNode.getImage());
            }
        };
    }
}

