/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.internal;

import net.sf.saxon.Configuration;
import net.sf.saxon.om.NodeInfo;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstElementNode;
import net.sourceforge.pmd.lang.rule.xpath.internal.AstTreeInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class ElementNodeTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    ElementNodeTest() {
    }

    @Test
    void testCompareOrder() {
        DummyNode.DummyRootNode root = this.helper.parse("(#foo)(#foo)");
        DummyNode c0 = (DummyNode)root.getChild(0);
        DummyNode c1 = (DummyNode)root.getChild(1);
        Configuration configuration = Configuration.newConfiguration();
        AstTreeInfo treeInfo = new AstTreeInfo((RootNode)root, configuration);
        Assertions.assertSame((Object)((Object)root), (Object)treeInfo.getRootNode().getUnderlyingNode());
        Assertions.assertEquals((int)9, (int)treeInfo.getRootNode().getNodeKind());
        AstElementNode rootElt = treeInfo.getRootNode().getRootElement();
        Assertions.assertSame((Object)((Object)root), (Object)rootElt.getUnderlyingNode());
        Assertions.assertEquals((int)1, (int)rootElt.getNodeKind());
        Assertions.assertSame((Object)rootElt, (Object)treeInfo.findWrapperFor((Node)root));
        AstElementNode elementFoo0 = (AstElementNode)rootElt.getChildren().get(0);
        Assertions.assertSame((Object)((Object)c0), (Object)elementFoo0.getUnderlyingNode());
        Assertions.assertSame((Object)elementFoo0, (Object)treeInfo.findWrapperFor((Node)c0));
        AstElementNode elementFoo1 = (AstElementNode)rootElt.getChildren().get(1);
        Assertions.assertSame((Object)((Object)c1), (Object)elementFoo1.getUnderlyingNode());
        Assertions.assertSame((Object)elementFoo1, (Object)treeInfo.findWrapperFor((Node)c1));
        Assertions.assertFalse((boolean)elementFoo0.isSameNodeInfo((NodeInfo)elementFoo1));
        Assertions.assertFalse((boolean)elementFoo1.isSameNodeInfo((NodeInfo)elementFoo0));
        Assertions.assertTrue((elementFoo0.compareOrder((NodeInfo)elementFoo1) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((elementFoo1.compareOrder((NodeInfo)elementFoo0) > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)0, (int)elementFoo0.compareOrder((NodeInfo)elementFoo0));
        Assertions.assertEquals((int)0, (int)elementFoo1.compareOrder((NodeInfo)elementFoo1));
    }

    @Test
    void verifyTextNodeType() {
        DummyNode.DummyRootNode root = this.helper.parse("(foo)(#text)");
        DummyNode c0 = (DummyNode)root.getChild(0);
        DummyNode c1 = (DummyNode)root.getChild(1);
        Configuration configuration = Configuration.newConfiguration();
        AstTreeInfo treeInfo = new AstTreeInfo((RootNode)root, configuration);
        AstElementNode rootElt = treeInfo.getRootNode().getRootElement();
        Assertions.assertSame((Object)((Object)root), (Object)rootElt.getUnderlyingNode());
        Assertions.assertEquals((int)1, (int)rootElt.getNodeKind());
        Assertions.assertSame((Object)rootElt, (Object)treeInfo.findWrapperFor((Node)root));
        AstElementNode elementFoo0 = (AstElementNode)rootElt.getChildren().get(0);
        Assertions.assertEquals((int)1, (int)elementFoo0.getNodeKind());
        Assertions.assertSame((Object)((Object)c0), (Object)elementFoo0.getUnderlyingNode());
        Assertions.assertSame((Object)elementFoo0, (Object)treeInfo.findWrapperFor((Node)c0));
        AstElementNode elementText1 = (AstElementNode)rootElt.getChildren().get(1);
        Assertions.assertEquals((int)3, (int)elementText1.getNodeKind());
        Assertions.assertSame((Object)((Object)c1), (Object)elementText1.getUnderlyingNode());
        Assertions.assertSame((Object)elementText1, (Object)treeInfo.findWrapperFor((Node)c1));
    }

    @Test
    void verifyCommentNodeType() {
        DummyNode.DummyRootNode root = this.helper.parse("(#comment)");
        DummyNode c1 = (DummyNode)root.getChild(0);
        Configuration configuration = Configuration.newConfiguration();
        AstTreeInfo treeInfo = new AstTreeInfo((RootNode)root, configuration);
        AstElementNode rootElt = treeInfo.getRootNode().getRootElement();
        AstElementNode elementComment = (AstElementNode)rootElt.getChildren().get(0);
        Assertions.assertEquals((Object)"#comment", (Object)c1.getXPathNodeName());
        Assertions.assertEquals((int)8, (int)elementComment.getNodeKind());
        Assertions.assertSame((Object)((Object)c1), (Object)elementComment.getUnderlyingNode());
        Assertions.assertSame((Object)elementComment, (Object)treeInfo.findWrapperFor((Node)c1));
    }
}

