/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.Attribute;
import net.sourceforge.pmd.lang.rule.xpath.NoAttribute;
import net.sourceforge.pmd.lang.rule.xpath.impl.AttributeAxisIterator;
import net.sourceforge.pmd.util.IteratorUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class NoAttributeTest {
    NoAttributeTest() {
    }

    @Test
    void testNoAttrInherited() {
        NodeNoInherited child = new NodeNoInherited();
        Set attrNames = IteratorUtil.toList((Iterator)child.getXPathAttributesIterator()).stream().map(Attribute::getName).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)attrNames.contains("SomeInt"));
        Assertions.assertTrue((boolean)attrNames.contains("Child"));
        Assertions.assertTrue((boolean)attrNames.contains("BeginLine"));
        Assertions.assertFalse((boolean)attrNames.contains("SomeLong"));
        Assertions.assertFalse((boolean)attrNames.contains("Image"));
        Assertions.assertFalse((boolean)attrNames.contains("SomeName"));
    }

    @Test
    void testNoAttrAll() {
        Assertions.assertTrue((0 < IteratorUtil.count((Iterator)new NodeAllAttr(12).getXPathAttributesIterator()) ? 1 : 0) != 0);
        NodeNoAttrAll child = new NodeNoAttrAll();
        Set attrNames = IteratorUtil.toList((Iterator)child.getXPathAttributesIterator()).stream().map(Attribute::getName).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)attrNames.contains("Image"));
        Assertions.assertFalse((boolean)attrNames.contains("MySuppressedAttr"));
    }

    @Test
    void testNoAttrAllIsNotInherited() {
        NodeNoAttrAllChild child = new NodeNoAttrAllChild();
        Set attrNames = IteratorUtil.toList((Iterator)child.getXPathAttributesIterator()).stream().map(Attribute::getName).collect(Collectors.toSet());
        Assertions.assertFalse((boolean)attrNames.contains("MySuppressedAttr"));
        Assertions.assertTrue((boolean)attrNames.contains("NotSuppressedAttr"));
    }

    public static class NodeNoAttrAllChild
    extends NodeNoAttrAll {
        public int getNotSuppressedAttr() {
            return 12;
        }
    }

    @NoAttribute(scope=NoAttribute.NoAttrScope.ALL)
    public static class NodeNoAttrAll
    extends DummyNodeParent {
        public int getMySuppressedAttr() {
            return 12;
        }
    }

    public static class NodeAllAttr
    extends DummyNodeParent {
        NodeAllAttr(int id) {
        }
    }

    @NoAttribute(scope=NoAttribute.NoAttrScope.INHERITED)
    public static class NodeNoInherited
    extends DummyNodeParent {
        @Override
        public int getSomeInt() {
            return 43;
        }

        @Override
        @NoAttribute
        public long getSomeLong() {
            return 43L;
        }

        @Override
        @NoAttribute(scope=NoAttribute.NoAttrScope.INHERITED)
        public String getImage() {
            return super.getImage();
        }

        public boolean isChild() {
            return true;
        }
    }

    private static class DummyNodeParent
    extends DummyNode {
        DummyNodeParent() {
        }

        public String getSomeName() {
            return "Foo";
        }

        public int getSomeInt() {
            return 42;
        }

        public long getSomeLong() {
            return 42L;
        }

        public long getSomeLong2() {
            return 42L;
        }

        @Override
        public Iterator<Attribute> getXPathAttributesIterator() {
            return new AttributeAxisIterator((Node)this);
        }
    }
}

