/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.internal;

import java.io.File;
import java.util.List;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReferenceId;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RuleSetReferenceIdTest {
    RuleSetReferenceIdTest() {
    }

    private static void assertRuleSetReferenceId(boolean expectedAbsolute, String expectedRuleSetFileName, boolean expectedAllRules, String expectedRuleName, String expectedNormalizedReference, RuleSetReferenceId reference) {
        Assertions.assertEquals((Object)expectedAbsolute, (Object)reference.isAbsolute(), (String)"Wrong absolute flag");
        Assertions.assertEquals((Object)expectedRuleSetFileName, (Object)reference.getRuleSetFileName(), (String)"Wrong RuleSet file name");
        Assertions.assertEquals((Object)expectedAllRules, (Object)reference.isAllRules(), (String)"Wrong all Rule reference");
        Assertions.assertEquals((Object)expectedRuleName, (Object)reference.getRuleName(), (String)"Wrong Rule name");
        Assertions.assertEquals((Object)expectedNormalizedReference, (Object)reference.toNormalizedReference(), (String)"Wrong normalized reference");
    }

    @Test
    void testCommaInSingleId() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RuleSetReferenceId("bad,id"));
    }

    @Test
    void testAbsoluteWithAbsolute() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RuleSetReferenceId("ruleset.xml/SomeRule", new RuleSetReferenceId("ruleset2.xml")));
    }

    @Test
    void testAbsoluteWithAbsolute2() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RuleSetReferenceId("someruleset.xml/SomeRule", new RuleSetReferenceId("someruleset.xml/SomeOtherRule")));
    }

    @Test
    void testRelativeWithRelative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RuleSetReferenceId("SomeRule", new RuleSetReferenceId("SomeOtherRule")));
    }

    @Test
    void testAbsoluteWithRelative() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RuleSetReferenceId("someruleset.xml/SomeRule", new RuleSetReferenceId("SomeOtherRule")));
    }

    @Test
    void testRelativeWithAbsolute() {
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "someruleset.xml", false, "SomeRule", "someruleset.xml/SomeRule", new RuleSetReferenceId("SomeRule", new RuleSetReferenceId("someruleset.xml/SomeOtherRule")));
    }

    @Test
    void testNullReference() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new RuleSetReferenceId(null));
    }

    @Test
    void testRelativeWithAbsoluteRuleSet() {
        RuleSetReferenceId relativeRuleSetReferenceId = new RuleSetReferenceId("MockRuleName");
        RuleSetReferenceIdTest.assertRuleSetReferenceId(false, null, false, "MockRuleName", "MockRuleName", relativeRuleSetReferenceId);
        RuleSetReferenceId absoluteRuleSetReferenceId = new RuleSetReferenceId("rulesets/java/basic.xml");
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/basic.xml", true, null, "rulesets/java/basic.xml", absoluteRuleSetReferenceId);
        RuleSetReferenceId pairRuleSetReferenceId = new RuleSetReferenceId("MockRuleName", absoluteRuleSetReferenceId);
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/basic.xml", false, "MockRuleName", "rulesets/java/basic.xml/MockRuleName", pairRuleSetReferenceId);
    }

    @Test
    void testExamplesFromJavaDoc() {
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/basic.xml", true, null, "rulesets/java/basic.xml", new RuleSetReferenceId("rulesets/java/basic.xml"));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/basic.xml", false, "EmptyCatchBlock", "rulesets/java/basic.xml/EmptyCatchBlock", new RuleSetReferenceId("rulesets/java/basic.xml/EmptyCatchBlock"));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(false, null, false, "EmptyCatchBlock", "EmptyCatchBlock", new RuleSetReferenceId("EmptyCatchBlock"));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "https://raw.githubusercontent.com/pmd/pmd/master/pmd-java/src/main/resources/rulesets/java/quickstart.xml", false, "ConstantsInInterface", "https://raw.githubusercontent.com/pmd/pmd/master/pmd-java/src/main/resources/rulesets/java/quickstart.xml/ConstantsInInterface", new RuleSetReferenceId("https://raw.githubusercontent.com/pmd/pmd/master/pmd-java/src/main/resources/rulesets/java/quickstart.xml/ConstantsInInterface"));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "https://example.org/ruleset/MyRule", true, null, "https://example.org/ruleset/MyRule", new RuleSetReferenceId("https://example.org/ruleset/MyRule"));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "https://example.org/ruleset.xml", false, "MyRule", "https://example.org/ruleset.xml/MyRule", new RuleSetReferenceId("https://example.org/ruleset.xml/MyRule"));
    }

    @Test
    void testConstructorGivenHttpUrlIdSucceedsAndProcessesIdCorrectly() {
        String sonarRulesetUrlId = "http://localhost:54321/profiles/export?format=pmd&language=java&name=Sonar%2520way";
        RuleSetReferenceId ruleSetReferenceId = new RuleSetReferenceId("  http://localhost:54321/profiles/export?format=pmd&language=java&name=Sonar%2520way  ");
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "http://localhost:54321/profiles/export?format=pmd&language=java&name=Sonar%2520way", true, null, "http://localhost:54321/profiles/export?format=pmd&language=java&name=Sonar%2520way", ruleSetReferenceId);
    }

    @Test
    void testOldSimpleRuleSetReferences() {
        RuleSetReferenceIdTest.assertRuleSetReferenceId(false, null, false, "dummy-basic", "dummy-basic", new RuleSetReferenceId("dummy-basic"));
    }

    @Test
    void testRuleSetReferenceWithSpaces() {
        RuleSetReferenceIdTest.assertRuleSetReferenceId(false, null, false, "MyRule", "MyRule", new RuleSetReferenceId(" MyRule "));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "ruleset.xml", true, null, "ruleset.xml", new RuleSetReferenceId(" ruleset.xml "));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "ruleset.xml", false, "MyRule", "ruleset.xml/MyRule", new RuleSetReferenceId(" ruleset.xml/MyRule "));
    }

    @Test
    void testMultipleRulesWithSpaces() {
        List references = RuleSetReferenceId.parse((String)"rulesets/dummy/basic.xml, rulesets/dummy/unusedcode.xml, rulesets/dummy2/basic.xml");
        Assertions.assertEquals((int)3, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/dummy/basic.xml", true, null, "rulesets/dummy/basic.xml", (RuleSetReferenceId)references.get(0));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/dummy/unusedcode.xml", true, null, "rulesets/dummy/unusedcode.xml", (RuleSetReferenceId)references.get(1));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/dummy2/basic.xml", true, null, "rulesets/dummy2/basic.xml", (RuleSetReferenceId)references.get(2));
    }

    @Test
    void testOneFullRuleSet() {
        List references = RuleSetReferenceId.parse((String)"rulesets/java/unusedcode.xml");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/unusedcode.xml", true, null, "rulesets/java/unusedcode.xml", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testOneFullRuleSetURL() {
        List references = RuleSetReferenceId.parse((String)"file://somepath/rulesets/java/unusedcode.xml");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "file://somepath/rulesets/java/unusedcode.xml", true, null, "file://somepath/rulesets/java/unusedcode.xml", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testMultipleFullRuleSet() {
        List references = RuleSetReferenceId.parse((String)"rulesets/java/unusedcode.xml,rulesets/java/basic.xml");
        Assertions.assertEquals((int)2, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/unusedcode.xml", true, null, "rulesets/java/unusedcode.xml", (RuleSetReferenceId)references.get(0));
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/basic.xml", true, null, "rulesets/java/basic.xml", (RuleSetReferenceId)references.get(1));
    }

    @Test
    void testUnknownRuleSet() {
        List references = RuleSetReferenceId.parse((String)"nonexistant.xml");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "nonexistant.xml", true, null, "nonexistant.xml", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testFullRuleSetAndRule() {
        List references = RuleSetReferenceId.parse((String)"rulesets/java/basic.xml/EmptyCatchBlock");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "rulesets/java/basic.xml", false, "EmptyCatchBlock", "rulesets/java/basic.xml/EmptyCatchBlock", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testFullRuleSetURLAndRule() {
        List references = RuleSetReferenceId.parse((String)"file://somepath/rulesets/java/unusedcode.xml/EmptyCatchBlock");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "file://somepath/rulesets/java/unusedcode.xml", false, "EmptyCatchBlock", "file://somepath/rulesets/java/unusedcode.xml/EmptyCatchBlock", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testRelativeRule() {
        List references = RuleSetReferenceId.parse((String)"EmptyCatchBlock");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(false, null, false, "EmptyCatchBlock", "EmptyCatchBlock", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testRelativePathRuleSet() {
        List references = RuleSetReferenceId.parse((String)"pmd/pmd-ruleset.xml");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "pmd/pmd-ruleset.xml", true, null, "pmd/pmd-ruleset.xml", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testAbsolutePathRuleSet() {
        List references = RuleSetReferenceId.parse((String)"/home/foo/pmd/pmd-ruleset.xml");
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, "/home/foo/pmd/pmd-ruleset.xml", true, null, "/home/foo/pmd/pmd-ruleset.xml", (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testFooRules() throws Exception {
        String fooRulesFile = new File("./src/test/resources/net/sourceforge/pmd/rulesets/foo-project/foo-rules").getCanonicalPath();
        List references = RuleSetReferenceId.parse((String)fooRulesFile);
        Assertions.assertEquals((int)1, (int)references.size());
        RuleSetReferenceIdTest.assertRuleSetReferenceId(true, fooRulesFile, true, null, fooRulesFile, (RuleSetReferenceId)references.get(0));
    }

    @Test
    void testNullRulesetString() throws Exception {
        List references = RuleSetReferenceId.parse(null);
        Assertions.assertTrue((boolean)references.isEmpty());
    }
}

