/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.sourceforge.pmd.internal.util.PredicateUtil;
import net.sourceforge.pmd.lang.rule.internal.LatticeRelation;
import net.sourceforge.pmd.lang.rule.internal.TopoOrder;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.pcollections.HashTreePSet;
import org.pcollections.MapPSet;

class LatticeRelationTest {
    LatticeRelationTest() {
    }

    @Test
    void testCustomTopo() {
        LatticeRelation<Set<Integer>, String, Set<String>> lattice = this.setLattice(PredicateUtil.always());
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2, 3}), (Object)"123");
        lattice.put((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[0]), (Object)"4");
        lattice.put((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[]{3}), (Object)"43");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"123", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2, 3})));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"4", (Object[])new String[]{"43"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"43", (Object[])new String[]{"123"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)3, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"43", (Object[])new String[]{"123", "4"}), (Object)lattice.get(Collections.emptySet()));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)5, (Object[])new Integer[0])));
    }

    @Test
    void testClearing() {
        LatticeRelation<Set<Integer>, String, Set<String>> lattice = this.setLattice(PredicateUtil.always());
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2}), (Object)"12");
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[0]), (Object)"1");
        lattice.put((Object)CollectionUtil.setOf((Object)3, (Object[])new Integer[0]), (Object)"3");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[]{"1"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2})));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"3", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)3, (Object[])new Integer[0])));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)5, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"1", (Object[])new String[]{"12", "3"}), (Object)lattice.get(Collections.emptySet()));
        lattice.clearValues();
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[0])));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[0])));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2})));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)3, (Object[])new Integer[0])));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)5, (Object[])new Integer[0])));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get(Collections.emptySet()));
    }

    @Test
    void testTopoFilter() {
        LatticeRelation<Set<Integer>, String, Set<String>> lattice = this.setLattice(it -> it.size() != 2);
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2, 3}), (Object)"123");
        lattice.put((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[0]), (Object)"4");
        lattice.put((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[]{3}), (Object)"43");
        lattice.put((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[]{3, 5}), (Object)"435");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"123", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2, 3})));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"4", (Object[])new String[]{"43", "435"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"123", (Object[])new String[]{"43", "435"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)3, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"123", (Object[])new String[]{"4", "43", "435"}), (Object)lattice.get(Collections.emptySet()));
        lattice.put((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[]{3, 6}), (Object)"436");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"4", (Object[])new String[]{"43", "435", "436"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[0])));
    }

    @Test
    void testInitialSetFilter() {
        LatticeRelation lattice = new LatticeRelation(LatticeRelationTest.setTopoOrder(), CollectionUtil.setOf((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2}), (Object[])new Set[]{CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2, 3}), CollectionUtil.setOf((Object)2, (Object[])new Integer[]{3}), Collections.emptySet()}), Objects::toString, Collectors.toSet());
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2, 3}), (Object)"123");
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2}), (Object)"12");
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[0]), (Object)"1");
        lattice.put((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[]{3, 4}), (Object)"234");
        lattice.put((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[]{3, 5, 6}), (Object)"435");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"123", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2, 3})));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[]{"123"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2})));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"123", (Object[])new String[]{"234"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[]{3})));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"1", (Object[])new String[]{"12", "123", "234", "435"}), (Object)lattice.get(Collections.emptySet()));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[0])));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)4, (Object[])new Integer[]{5})));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[]{3, 4})));
        lattice.put((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[]{3, 4}), (Object)"234*");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"123", (Object[])new String[]{"234", "234*"}), (Object)lattice.get((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[]{3})));
    }

    @Test
    void testDiamond() {
        LatticeRelation<Set<Integer>, String, Set<String>> lattice = this.setLattice(PredicateUtil.always());
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2}), (Object)"12");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[0]), (Object)lattice.get(Collections.emptySet()));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)2, (Object[])new Integer[0])));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"12", (Object[])new String[0]), (Object)lattice.get((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2})));
    }

    @Test
    void testFilterOnChainSetup() {
        LatticeRelation<String, String, Set<String>> lattice = this.stringLattice(PredicateUtil.always());
        lattice.put((Object)"abc", (Object)"val");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[0]), (Object)lattice.get((Object)""));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[0]), (Object)lattice.get((Object)"abc"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[0]), (Object)lattice.get((Object)"bc"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[0]), (Object)lattice.get((Object)"c"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)"d"));
    }

    @Test
    void testFilterOnChain() {
        LatticeRelation<String, String, Set<String>> lattice = this.stringLattice(s -> s.length() != 2 && s.length() != 1);
        lattice.put((Object)"abc", (Object)"val");
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[0]), (Object)lattice.get((Object)""));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[0]), (Object)lattice.get((Object)"abc"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)"bc"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)"c"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)"d"));
    }

    @Test
    void testTransitiveSucc() {
        LatticeRelation<String, String, Set<String>> lattice = this.stringLattice(s -> s.equals("c") || s.equals("bc"));
        lattice.put((Object)"abc", (Object)"val");
        lattice.put((Object)"bc", (Object)"v2");
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.transitiveQuerySuccs((Object)""));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)""));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"c", (Object[])new String[]{"bc"}), (Object)lattice.transitiveQuerySuccs((Object)"abc"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)"abc"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"c", (Object[])new String[0]), (Object)lattice.transitiveQuerySuccs((Object)"bc"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[]{"v2"}), (Object)lattice.get((Object)"bc"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.transitiveQuerySuccs((Object)"c"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"val", (Object[])new String[]{"v2"}), (Object)lattice.get((Object)"c"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.transitiveQuerySuccs((Object)"d"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)"d"));
    }

    @Test
    void testTransitiveSuccWithHoleInTheMiddle() {
        LatticeRelation<String, String, Set<String>> lattice = this.stringLattice(CollectionUtil.setOf((Object)"abc", (Object[])new String[]{"bbc", "c"})::contains);
        lattice.put((Object)"abc", (Object)"v1");
        lattice.put((Object)"bbc", (Object)"v2");
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.transitiveQuerySuccs((Object)""));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)""));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"c", (Object[])new String[0]), (Object)lattice.transitiveQuerySuccs((Object)"abc"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"v1", (Object[])new String[0]), (Object)lattice.get((Object)"abc"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"c", (Object[])new String[0]), (Object)lattice.transitiveQuerySuccs((Object)"bbc"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"v2", (Object[])new String[0]), (Object)lattice.get((Object)"bbc"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.get((Object)"bc"));
        Assertions.assertEquals(Collections.emptySet(), (Object)lattice.transitiveQuerySuccs((Object)"c"));
        Assertions.assertEquals((Object)CollectionUtil.setOf((Object)"v1", (Object[])new String[]{"v2"}), (Object)lattice.get((Object)"c"));
    }

    @Test
    void testToString() {
        LatticeRelation<Set<Integer>, String, Set<String>> lattice = this.setLattice(set -> set.size() < 2);
        lattice.put((Object)CollectionUtil.setOf((Object)1, (Object[])new Integer[]{2}), (Object)"12");
        Assertions.assertEquals((Object)"strict digraph {\nn0 [ shape=box, color=black, label=\"[1, 2]\" ];\nn1 [ shape=box, color=green, label=\"[1]\" ];\nn2 [ shape=box, color=green, label=\"[2]\" ];\nn3 [ shape=box, color=green, label=\"[]\" ];\nn0 -> n1;\nn0 -> n2;\nn0 -> n3;\nn1 -> n3;\nn2 -> n3;\n}", (Object)lattice.toString());
    }

    @Test
    void testCycleDetection() {
        List<String> cycle = Arrays.asList("a", "b", "c", "d");
        TopoOrder cyclicOrder = str -> {
            int i = cycle.indexOf(str);
            return Collections.singletonList((String)cycle.get((i + 1) % cycle.size()));
        };
        LatticeRelation lattice = new LatticeRelation(cyclicOrder, PredicateUtil.always(), Objects::toString, Collectors.toSet());
        IllegalStateException exception = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> lattice.put((Object)"a", (Object)"1"));
        Assertions.assertEquals((Object)"Cycle in graph: a -> b -> c -> d -> a", (Object)exception.getMessage());
    }

    private @NonNull LatticeRelation<String, String, Set<String>> stringLattice(Predicate<String> filter) {
        return new LatticeRelation(LatticeRelationTest.stringTopoOrder(), filter, Objects::toString, Collectors.toSet());
    }

    private @NonNull LatticeRelation<Set<Integer>, String, Set<String>> setLattice(Predicate<Set<Integer>> filter) {
        return new LatticeRelation(LatticeRelationTest.setTopoOrder(), filter, Objects::toString, Collectors.toSet());
    }

    private static <T> TopoOrder<Set<T>> setTopoOrder() {
        return node -> {
            HashSet<MapPSet> successors = new HashSet<MapPSet>();
            for (Object s : node) {
                MapPSet minus = HashTreePSet.empty().plusAll((Collection)node).minus(s);
                successors.add(minus);
            }
            return successors;
        };
    }

    private static TopoOrder<String> stringTopoOrder() {
        return str -> str.isEmpty() ? Collections.emptyList() : Collections.singletonList(str.substring(1));
    }
}

