/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import net.sourceforge.pmd.DummyParsingHelper;
import net.sourceforge.pmd.PmdCoreTestUtils;
import net.sourceforge.pmd.lang.ast.DummyNode;
import net.sourceforge.pmd.lang.ast.DummyNodeWithDeprecatedAttribute;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.TextRegion;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.xpath.XPathRule;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.ReportTestUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class XPathRuleTest {
    @RegisterExtension
    private final DummyParsingHelper helper = new DummyParsingHelper();

    XPathRuleTest() {
    }

    @Test
    void testAttributeDeprecation() throws Exception {
        this.testDeprecation(XPathVersion.DEFAULT);
    }

    void testDeprecation(XPathVersion version) throws Exception {
        XPathRule xpr = this.makeRule(version, "SomeRule");
        DummyNode.DummyRootNode firstNode = this.newNode();
        String log = SystemLambda.tapSystemErrAndOut(() -> {
            Report report = ReportTestUtil.getReportForRuleApply((Rule)xpr, (Node)firstNode);
            Assertions.assertEquals((int)1, (int)report.getViolations().size());
        });
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"Use of deprecated attribute 'dummyNode/@Size' by XPath rule 'SomeRule'"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"Use of deprecated attribute 'dummyNode/@Name' by XPath rule 'SomeRule', please use @Image instead"));
        log = SystemLambda.tapSystemErrAndOut(() -> {
            Report report = ReportTestUtil.getReportForRuleApply((Rule)xpr, (Node)this.newNode());
            Assertions.assertEquals((int)1, (int)report.getViolations().size());
        });
        Assertions.assertEquals((Object)"", (Object)log);
        log = SystemLambda.tapSystemErrAndOut(() -> {
            Report report = ReportTestUtil.getReportForRuleApply(xpr.deepCopy(), (Node)this.newNode());
            Assertions.assertEquals((int)1, (int)report.getViolations().size());
        });
        Assertions.assertEquals((Object)"", (Object)log);
        XPathRule otherRule = this.makeRule(version, "OtherRule");
        otherRule.setRuleSetName("rset.xml");
        log = SystemLambda.tapSystemErrAndOut(() -> {
            Report report = ReportTestUtil.getReportForRuleApply((Rule)otherRule, (Node)firstNode);
            Assertions.assertEquals((int)1, (int)report.getViolations().size());
        });
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"Use of deprecated attribute 'dummyNode/@Size' by XPath rule 'OtherRule' (in ruleset 'rset.xml')"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"Use of deprecated attribute 'dummyNode/@Name' by XPath rule 'OtherRule' (in ruleset 'rset.xml'), please use @Image instead"));
    }

    XPathRule makeRule(XPathVersion version, String name) {
        XPathRule xpr = new XPathRule(version, "//dummyNode[@Size >= 2 and @Name='foo']");
        xpr.setName(name);
        PmdCoreTestUtils.setDummyLanguage(xpr);
        xpr.setMessage("gotcha");
        return xpr;
    }

    XPathRule makeXPath(String xpathExpr) {
        XPathRule xpr = new XPathRule(XPathVersion.DEFAULT, xpathExpr);
        PmdCoreTestUtils.setDummyLanguage(xpr);
        xpr.setName("name");
        xpr.setMessage("gotcha");
        return xpr;
    }

    @Test
    void testFileNameInXpath() {
        Report report = this.executeRule((Rule)this.makeXPath("//*[pmd:fileName() = 'Foo.cls']"), this.newRoot("src/Foo.cls"));
        MatcherAssert.assertThat((Object)report.getViolations(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    void testBeginLine() {
        Report report = this.executeRule((Rule)this.makeXPath("//*[pmd:startLine(.)=1]"), this.newRoot("src/Foo.cls"));
        MatcherAssert.assertThat((Object)report.getViolations(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    void testBeginCol() {
        Report report = this.executeRule((Rule)this.makeXPath("//*[pmd:startColumn(.)=1]"), this.newRoot("src/Foo.cls"));
        MatcherAssert.assertThat((Object)report.getViolations(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    void testEndLine() {
        Report report = this.executeRule((Rule)this.makeXPath("//*[pmd:endLine(.)=1]"), this.newRoot("src/Foo.cls"));
        MatcherAssert.assertThat((Object)report.getViolations(), (Matcher)Matchers.hasSize((int)1));
    }

    @Test
    void testEndColumn() {
        Report report = this.executeRule((Rule)this.makeXPath("//*[pmd:endColumn(.)>1]"), this.newRoot("src/Foo.cls"));
        MatcherAssert.assertThat((Object)report.getViolations(), (Matcher)Matchers.hasSize((int)1));
    }

    Report executeRule(Rule rule, DummyNode node) {
        return ReportTestUtil.getReportForRuleApply(rule, (Node)node);
    }

    DummyNode.DummyRootNode newNode() {
        DummyNode.DummyRootNode root = this.newRoot("file");
        DummyNodeWithDeprecatedAttribute dummy = new DummyNodeWithDeprecatedAttribute();
        root.addChild(dummy, 0);
        dummy.setRegion(TextRegion.fromOffsetLength((int)0, (int)1));
        return root;
    }

    public DummyNode.DummyRootNode newRoot(String fileName) {
        return this.helper.parse("dummy code", fileName);
    }
}

