/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import net.sourceforge.pmd.PmdCoreTestUtils;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.RuleSetLoader;
import net.sourceforge.pmd.lang.rule.RulesetFactoryTestBase;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.internal.ResourceLoader;
import net.sourceforge.pmd.util.internal.xml.SchemaConstant;
import net.sourceforge.pmd.util.internal.xml.SchemaConstants;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class RuleSetFactoryTest
extends RulesetFactoryTestBase {
    private static final String TEST_RULESET_1 = "net/sourceforge/pmd/lang/rule/TestRuleset1.xml";
    private static final String REFERENCE_RULESET = "net/sourceforge/pmd/lang/rule/reference-ruleset.xml";
    private static final String REF_OVERRIDE_ORIGINAL_NAME = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n <description>testdesc</description>\n <rule \n\n  ref=\"net/sourceforge/pmd/lang/rule/TestRuleset1.xml/MockRule1\" message=\"TestMessageOverride\"> \n\n </rule>\n</ruleset>";
    private static final String REF_MISSPELLED_XREF = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n\n <description>testdesc</description>\n <rule \n  ref=\"net/sourceforge/pmd/lang/rule/TestRuleset1.xml/FooMockRule1\"> \n </rule>\n</ruleset>";
    private static final String REF_OVERRIDE_ORIGINAL_NAME_ONE_ELEM = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n <description>testdesc</description>\n <rule ref=\"net/sourceforge/pmd/lang/rule/TestRuleset1.xml/MockRule1\" message=\"TestMessageOverride\"/> \n\n</ruleset>";
    private static final String REF_OVERRIDE = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n <description>testdesc</description>\n <rule \n  ref=\"net/sourceforge/pmd/lang/rule/TestRuleset1.xml/MockRule4\" \n  name=\"TestNameOverride\" \n\n  message=\"Test message override\"> \n  <description>Test description override</description>\n  <example>Test example override</example>\n  <priority>3</priority>\n  <properties>\n   <property name=\"test2\" description=\"test2\" type=\"String\" value=\"override2\"/>\n   <property name=\"test3\" type=\"String\" description=\"test3\"><value>override3</value></property>\n\n  </properties>\n </rule>\n</ruleset>";
    private static final String REF_OVERRIDE_NONEXISTENT = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n\n <description>testdesc</description>\n <rule \n  ref=\"net/sourceforge/pmd/lang/rule/TestRuleset1.xml/MockRule4\" \n  name=\"TestNameOverride\" \n\n  message=\"Test message override\"> \n  <description>Test description override</description>\n  <example>Test example override</example>\n  <priority>3</priority>\n  <properties>\n   <property name=\"test4\" description=\"test4\" type=\"String\" value=\"new property\"/>\n  </properties>\n </rule>\n</ruleset>";
    private static final String REF_INTERNAL_TO_INTERNAL = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n <description>testdesc</description>\n<rule \n\nlanguage=\"dummy\" \nname=\"MockRuleName\" \nmessage=\"avoid the mock rule\" \nclass=\"net.sourceforge.pmd.lang.rule.MockRule\">\n</rule>\n <rule ref=\"MockRuleName\" name=\"MockRuleNameRef\"/> \n</ruleset>";
    private static final String REF_INTERNAL_TO_INTERNAL_CHAIN = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n <description>testdesc</description>\n<rule \n\nlanguage=\"dummy\" \nname=\"MockRuleName\" \nmessage=\"avoid the mock rule\" \nclass=\"net.sourceforge.pmd.lang.rule.MockRule\">\n</rule>\n <rule ref=\"MockRuleName\" name=\"MockRuleNameRef\"><priority>2</priority></rule> \n <rule ref=\"MockRuleNameRef\" name=\"MockRuleNameRefRef\"><priority>1</priority></rule> \n</ruleset>";
    private static final String REF_INTERNAL_TO_EXTERNAL = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n <description>testdesc</description>\n<rule \n\nname=\"ExternalRefRuleName\" \nref=\"net/sourceforge/pmd/lang/rule/TestRuleset1.xml/MockRule1\"/>\n <rule ref=\"ExternalRefRuleName\" name=\"ExternalRefRuleNameRef\"/> \n</ruleset>";
    private static final String REF_INTERNAL_TO_EXTERNAL_CHAIN = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n <description>testdesc</description>\n<rule \n\nname=\"ExternalRefRuleName\" \nref=\"net/sourceforge/pmd/lang/rule/TestRuleset2.xml/TestRule\"/>\n <rule ref=\"ExternalRefRuleName\" name=\"ExternalRefRuleNameRef\"><priority>2</priority></rule> \n\n <rule ref=\"ExternalRefRuleNameRef\" name=\"ExternalRefRuleNameRefRef\"><priority>1</priority></rule> \n\n</ruleset>";
    private static final String EMPTY_RULESET = RuleSetFactoryTest.rulesetXml(new String[0]);
    private static final String SINGLE_RULE = RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rule(RuleSetFactoryTest.dummyRuleDefAttrs(), RuleSetFactoryTest.priority("3")));
    private static final String SINGLE_RULE_EMPTY_REF = "<?xml version=\"1.0\"?>\n<ruleset name=\"test\">\n<description>testdesc</description>\n<rule \nlanguage=\"dummy\" \nref=\"\" \nname=\"MockRuleName\" \nmessage=\"avoid the mock rule\" \nclass=\"net.sourceforge.pmd.lang.rule.MockRule\">\n<priority>3</priority>\n</rule></ruleset>";
    private static final String PROPERTIES = RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rule(RuleSetFactoryTest.dummyRuleDefAttrs(), RuleSetFactoryTest.description("testdesc2"), RuleSetFactoryTest.properties("<property name=\"fooBoolean\" description=\"test\" type=\"Boolean\" value=\"true\" />\n", "<property name=\"fooChar\" description=\"test\" type=\"Character\" value=\"B\" />\n", "<property name=\"fooInt\" description=\"test\" type=\"Integer\" min=\"1\" max=\"10\" value=\"3\" />", "<property name=\"fooDouble\" description=\"test\" type=\"Double\" min=\"1.0\" max=\"9.0\" value=\"3.0\"  />\n", "<property name=\"fooString\" description=\"test\" type=\"String\" value=\"bar\" />\n")));
    private static final String XPATH = RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rule(RuleSetFactoryTest.dummyRuleDefAttrs(), RuleSetFactoryTest.description("testDesc"), RuleSetFactoryTest.properties("<property name=\"xpath\" description=\"test\" type=\"String\">\n<value>\n<![CDATA[ //Block ]]>\n</value></property>")));
    private static final String DEPRECATED_RULE_RULESET_NAME = "net/sourceforge/pmd/lang/rule/TestRuleset1.xml";
    private static final String DEPRECATED_RULE_NAME = "MockRule3";
    private static final String REFERENCE_TO_DEPRECATED_RULE = RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.ruleRef("net/sourceforge/pmd/lang/rule/TestRuleset1.xml/MockRule3"));
    private static final String REFERENCE_TO_RULESET_WITH_DEPRECATED_RULE = RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rulesetRef("net/sourceforge/pmd/lang/rule/TestRuleset1.xml", new String[0]));
    private static final String INCLUDE_EXCLUDE_RULESET = RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.includePattern("include1"), RuleSetFactoryTest.includePattern("include2"), RuleSetFactoryTest.excludePattern("exclude1"), RuleSetFactoryTest.excludePattern("exclude2"), RuleSetFactoryTest.excludePattern("exclude3"));

    RuleSetFactoryTest() {
    }

    @Test
    void testRuleSetFileName() {
        RuleSet rs = new RuleSetLoader().loadFromString("dummyRuleset.xml", EMPTY_RULESET);
        Assertions.assertEquals((Object)"dummyRuleset.xml", (Object)rs.getFileName());
        rs = new RuleSetLoader().loadFromResource("net/sourceforge/pmd/lang/rule/TestRuleset1.xml");
        Assertions.assertEquals((Object)rs.getFileName(), (Object)"net/sourceforge/pmd/lang/rule/TestRuleset1.xml", (String)"wrong RuleSet file name");
    }

    @Test
    void testRefs() {
        RuleSet rs = new RuleSetLoader().loadFromResource("net/sourceforge/pmd/lang/rule/TestRuleset1.xml");
        Assertions.assertNotNull((Object)rs.getRuleByName("TestRuleRef"));
    }

    @Test
    void testExtendedReferences() throws Exception {
        InputStream in = new ResourceLoader().loadClassPathResourceAsStream(REFERENCE_RULESET);
        Assertions.assertNotNull((Object)in, (String)"Test ruleset not found - can't continue with test!");
        in.close();
        RuleSet rs = new RuleSetLoader().loadFromResource(REFERENCE_RULESET);
        Assertions.assertNotNull((Object)rs.getRuleByName("MockRule1"));
        Assertions.assertNotNull((Object)rs.getRuleByName("MockRule2"));
        Assertions.assertNotNull((Object)rs.getRuleByName(DEPRECATED_RULE_NAME));
        Assertions.assertNotNull((Object)rs.getRuleByName("TestRuleRef"));
        Assertions.assertNotNull((Object)rs.getRuleByName("TestRule"));
        Assertions.assertNull((Object)rs.getRuleByName("TestRule2Ruleset2"));
        Rule mockRule3 = rs.getRuleByName(DEPRECATED_RULE_NAME);
        Assertions.assertEquals((Object)"Overridden message", (Object)mockRule3.getMessage());
        Assertions.assertEquals((int)2, (int)mockRule3.getPriority().getPriority());
        Rule mockRule2 = rs.getRuleByName("MockRule2");
        Assertions.assertEquals((Object)"Just combine them!", (Object)mockRule2.getMessage());
        Assertions.assertNotNull((Object)rs.getRuleByName("MockRule2"));
        Rule mockRule1 = rs.getRuleByName("MockRule1");
        Assertions.assertNotNull((Object)mockRule1);
        PropertyDescriptor prop = mockRule1.getPropertyDescriptor("testIntProperty");
        Object property = mockRule1.getProperty(prop);
        Assertions.assertEquals((Object)"5", (Object)String.valueOf(property));
        Assertions.assertNotNull((Object)rs.getRuleByName("Ruleset3Rule2"));
        Assertions.assertNull((Object)rs.getRuleByName("Ruleset3Rule1"));
        Rule ruleset4Rule1 = rs.getRuleByName("Ruleset4Rule1");
        Assertions.assertNotNull((Object)ruleset4Rule1);
        Assertions.assertEquals((int)5, (int)ruleset4Rule1.getPriority().getPriority());
        Assertions.assertNotNull((Object)rs.getRuleByName("Ruleset4Rule1"));
        Rule ruleset4Rule2 = rs.getRuleByName("Ruleset4Rule2");
        Assertions.assertNotNull((Object)ruleset4Rule2);
        Assertions.assertEquals((int)2, (int)ruleset4Rule2.getPriority().getPriority());
    }

    @Test
    void testRuleSetNotFound() {
        Assertions.assertThrows(RuleSetLoadException.class, () -> new RuleSetLoader().loadFromResource("fooooo"));
    }

    @Test
    void testCreateEmptyRuleSet() {
        RuleSet rs = this.loadRuleSet(EMPTY_RULESET);
        Assertions.assertEquals((Object)"Custom ruleset", (Object)rs.getName());
        Assertions.assertEquals((int)0, (int)rs.size());
    }

    @Test
    void testSingleRule() {
        RuleSet rs = this.loadRuleSet(SINGLE_RULE);
        Assertions.assertEquals((int)1, (int)rs.size());
        Rule r = (Rule)rs.getRules().iterator().next();
        Assertions.assertEquals((Object)"MockRuleName", (Object)r.getName());
        Assertions.assertEquals((Object)"net.sourceforge.pmd.lang.rule.MockRuleWithNoProperties", (Object)r.getRuleClass());
        Assertions.assertEquals((Object)"avoid the mock rule", (Object)r.getMessage());
    }

    @Test
    void testSingleRuleEmptyRef() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSet(SINGLE_RULE_EMPTY_REF);
            Assertions.assertEquals((int)1, (int)rs.size());
            Rule r = (Rule)rs.getRules().iterator().next();
            Assertions.assertEquals((Object)"MockRuleName", (Object)r.getName());
            Assertions.assertEquals((Object)"net.sourceforge.pmd.lang.rule.MockRule", (Object)r.getRuleClass());
            Assertions.assertEquals((Object)"avoid the mock rule", (Object)r.getMessage());
        });
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"Empty ref attribute"));
    }

    @Test
    void testMultipleRules() {
        RuleSet rs = this.loadRuleSet(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.NAME, "MockRuleName1"), new String[0]), RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.NAME, "MockRuleName2"), new String[0])));
        Assertions.assertEquals((int)2, (int)rs.size());
        HashSet<String> expected = new HashSet<String>();
        expected.add("MockRuleName1");
        expected.add("MockRuleName2");
        for (Rule rule : rs.getRules()) {
            Assertions.assertTrue((boolean)expected.contains(rule.getName()));
        }
    }

    @Test
    void testSingleRuleWithPriority() {
        Rule rule = this.loadFirstRule(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rule(RuleSetFactoryTest.dummyRuleDefAttrs(), RuleSetFactoryTest.priority("3"))));
        Assertions.assertEquals((Object)RulePriority.MEDIUM, (Object)rule.getPriority());
    }

    @Test
    void testProps() {
        Rule r = this.loadFirstRule(PROPERTIES);
        Assertions.assertEquals((Object)"bar", (Object)r.getProperty(r.getPropertyDescriptor("fooString")));
        Assertions.assertEquals((Object)3, (Object)r.getProperty(r.getPropertyDescriptor("fooInt")));
        Assertions.assertEquals((Object)true, (Object)r.getProperty(r.getPropertyDescriptor("fooBoolean")));
        Assertions.assertEquals((double)3.0, (double)((Double)r.getProperty(r.getPropertyDescriptor("fooDouble"))), (double)0.05);
        Assertions.assertNull((Object)r.getPropertyDescriptor("BuggleFish"));
        Assertions.assertNotSame((Object)r.getDescription().indexOf("testdesc2"), (Object)-1);
    }

    @Test
    void testStringMultiPropertyDefaultDelimiter() {
        Rule r = this.loadFirstRule(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule(RuleSetFactoryTest.priority("3"), RuleSetFactoryTest.properties("<property name=\"packageRegEx\" value=\"com.aptsssss,com.abc\" \ntype=\"List[String]\" description=\"valid packages\"/>"))));
        Object propValue = r.getProperty(r.getPropertyDescriptor("packageRegEx"));
        Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"com.aptsssss", (Object[])new String[]{"com.abc"}), (Object)propValue);
    }

    @Test
    void testEmptyStringProperty() {
        Rule r = this.loadFirstRule("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"test\">\n  <description>ruleset desc</description>\n     <rule name=\"myRule\" message=\"Do not place to this package. Move to \n{0} package/s instead.\" \nclass=\"net.sourceforge.pmd.RuleWithProperties\" language=\"dummy\">\n         <description>Please move your class to the right folder(rest \nfolder)</description>\n         <priority>2</priority>\n         <properties>\n             <property name=\"stringProperty\" value=\"\" />\n         </properties></rule></ruleset>");
        PropertyDescriptor prop = r.getPropertyDescriptor("stringProperty");
        String value = (String)r.getProperty(prop);
        Assertions.assertEquals((Object)"", (Object)value);
    }

    @Test
    void testRuleSetWithDeprecatedRule() {
        RuleSet rs = this.loadRuleSet("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"ruleset\">\n  <description>ruleset desc</description>\n     <rule deprecated=\"true\" ref=\"rulesets/dummy/basic.xml/DummyBasicMockRule\"/></ruleset>");
        Assertions.assertEquals((int)1, (int)rs.getRules().size());
        Rule rule = rs.getRuleByName("DummyBasicMockRule");
        Assertions.assertNotNull((Object)rule);
    }

    @Test
    void testRuleSetWithDeprecatedButRenamedRule() throws Exception {
        SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSetWithDeprecationWarnings("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"test\">\n  <description>ruleset desc</description>\n     <rule deprecated=\"true\" ref=\"NewName\" name=\"OldName\"/>     <rule name=\"NewName\" message=\"m\" class=\"net.sourceforge.pmd.lang.rule.xpath.XPathRule\" language=\"dummy\">         <description>d</description>\n         <priority>2</priority>\n     </rule></ruleset>");
            Assertions.assertEquals((int)1, (int)rs.getRules().size());
            Rule rule = rs.getRuleByName("NewName");
            Assertions.assertNotNull((Object)rule);
            Assertions.assertNull((Object)rs.getRuleByName("OldName"));
        });
        this.verifyNoWarnings();
    }

    @Test
    void testRuleSetWithDeprecatedRenamedRuleForDoc() {
        RuleSetLoader loader = new RuleSetLoader().includeDeprecatedRuleReferences(true);
        RuleSet rs = loader.loadFromString("ruleset.xml", "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"test\">\n  <description>ruleset desc</description>\n     <rule deprecated=\"true\" ref=\"NewName\" name=\"OldName\"/>     <rule name=\"NewName\" message=\"m\" class=\"net.sourceforge.pmd.lang.rule.xpath.XPathRule\" language=\"dummy\">         <description>d</description>\n         <priority>2</priority>\n     </rule></ruleset>");
        Assertions.assertEquals((int)2, (int)rs.getRules().size());
        Assertions.assertNotNull((Object)rs.getRuleByName("NewName"));
        Assertions.assertNotNull((Object)rs.getRuleByName("OldName"));
    }

    @Test
    void testRuleSetReferencesADeprecatedRenamedRule() throws Exception {
        SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSetWithDeprecationWarnings("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"test\">\n  <description>ruleset desc</description>\n     <rule ref=\"rulesets/dummy/basic.xml/OldNameOfDummyBasicMockRule\"/></ruleset>");
            Assertions.assertEquals((int)1, (int)rs.getRules().size());
            Rule rule = rs.getRuleByName("OldNameOfDummyBasicMockRule");
            Assertions.assertNotNull((Object)rule);
        });
        this.verifyFoundAWarningWithMessage(RuleSetFactoryTest.containing("Use Rule name rulesets/dummy/basic.xml/DummyBasicMockRule instead of the deprecated Rule name rulesets/dummy/basic.xml/OldNameOfDummyBasicMockRule"));
    }

    @Test
    void testRuleSetReferencesRulesetWithADeprecatedRenamedRule() throws Exception {
        SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSetWithDeprecationWarnings("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"test\">\n  <description>ruleset desc</description>\n     <rule ref=\"rulesets/dummy/basic.xml\"/></ruleset>");
            Assertions.assertEquals((int)2, (int)rs.getRules().size());
            Assertions.assertNotNull((Object)rs.getRuleByName("DummyBasicMockRule"));
            Assertions.assertNotNull((Object)rs.getRuleByName("SampleXPathRule"));
        });
        this.verifyNoWarnings();
    }

    @Test
    void testRuleSetReferencesRulesetWithAExcludedDeprecatedRule() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSetWithDeprecationWarnings("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"test\">\n  <description>ruleset desc</description>\n     <rule ref=\"rulesets/dummy/basic.xml\"><exclude name=\"DeprecatedRule\"/></rule></ruleset>");
            Assertions.assertEquals((int)2, (int)rs.getRules().size());
            Assertions.assertNotNull((Object)rs.getRuleByName("DummyBasicMockRule"));
            Assertions.assertNotNull((Object)rs.getRuleByName("SampleXPathRule"));
        });
        Assertions.assertTrue((boolean)log.isEmpty());
    }

    @Test
    void testRuleSetReferencesRulesetWithAExcludedNonExistingRule() throws Exception {
        SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSetWithDeprecationWarnings(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rulesetRef("rulesets/dummy/basic.xml", RuleSetFactoryTest.excludeRule("NonExistingRule"))));
            Assertions.assertEquals((int)2, (int)rs.getRules().size());
            Assertions.assertNotNull((Object)rs.getRuleByName("DummyBasicMockRule"));
            Assertions.assertNotNull((Object)rs.getRuleByName("SampleXPathRule"));
        });
        this.verifyFoundWarningWithMessage(Mockito.never(), RuleSetFactoryTest.containing("Discontinue using Rule rulesets/dummy/basic.xml/DeprecatedRule"));
        this.verifyFoundAWarningWithMessage(RuleSetFactoryTest.containing("Exclude pattern 'NonExistingRule' did not match any rule in ruleset"));
    }

    @Test
    void testRuleSetReferencesDeprecatedRuleset() throws Exception {
        SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSetWithDeprecationWarnings(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rulesetRef("rulesets/dummy/deprecated.xml", new String[0])));
            Assertions.assertEquals((int)2, (int)rs.getRules().size());
            Assertions.assertNotNull((Object)rs.getRuleByName("DummyBasicMockRule"));
            Assertions.assertNotNull((Object)rs.getRuleByName("SampleXPathRule"));
        });
        this.verifyFoundAWarningWithMessage(RuleSetFactoryTest.containing("The RuleSet rulesets/dummy/deprecated.xml has been deprecated and will be removed in PMD"));
    }

    @Test
    void testRuleSetReferencesRulesetWithAMovedRule() throws Exception {
        SystemLambda.tapSystemErr(() -> {
            RuleSet rs = this.loadRuleSetWithDeprecationWarnings(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.ruleRef("rulesets/dummy/basic2.xml")));
            Assertions.assertEquals((int)1, (int)rs.getRules().size());
            Assertions.assertNotNull((Object)rs.getRuleByName("DummyBasic2MockRule"));
        });
        this.verifyFoundWarningWithMessage(Mockito.never(), RuleSetFactoryTest.containing("Use Rule name rulesets/dummy/basic.xml/DummyBasicMockRule instead of the deprecated Rule name rulesets/dummy/basic2.xml/DummyBasicMockRule"));
    }

    @Test
    void testXPath() {
        Rule r = this.loadFirstRule(XPATH);
        PropertyDescriptor xpathProperty = r.getPropertyDescriptor("xpath");
        Assertions.assertNotNull((Object)xpathProperty, (String)"xpath property descriptor");
        Assertions.assertNotSame((Object)((String)r.getProperty(xpathProperty)).indexOf("//Block"), (Object)-1);
    }

    @Test
    void testExternalReferenceOverride() {
        Rule r = this.loadFirstRule(REF_OVERRIDE);
        Assertions.assertEquals((Object)"TestNameOverride", (Object)r.getName());
        Assertions.assertEquals((Object)"Test message override", (Object)r.getMessage());
        Assertions.assertEquals((Object)"Test description override", (Object)r.getDescription());
        Assertions.assertEquals((int)2, (int)r.getExamples().size(), (String)"Test that both example are stored");
        Assertions.assertEquals((Object)"Test example override", r.getExamples().get(1));
        Assertions.assertEquals((Object)RulePriority.MEDIUM, (Object)r.getPriority());
        PropertyDescriptor test2Descriptor = r.getPropertyDescriptor("test2");
        Assertions.assertNotNull((Object)test2Descriptor, (String)"test2 descriptor");
        Assertions.assertEquals((Object)"override2", (Object)r.getProperty(test2Descriptor));
        PropertyDescriptor test3Descriptor = r.getPropertyDescriptor("test3");
        Assertions.assertNotNull((Object)test3Descriptor, (String)"test3 descriptor");
        Assertions.assertEquals((Object)"override3", (Object)r.getProperty(test3Descriptor));
    }

    @Test
    void testExternalReferenceOverrideNonExistent() {
        Assertions.assertThrows(RuleSetLoadException.class, () -> this.loadFirstRule(REF_OVERRIDE_NONEXISTENT));
        this.verifyFoundAnErrorWithMessage(RuleSetFactoryTest.containing("Cannot set non-existent property 'test4' on rule TestNameOverride"));
    }

    @Test
    void testReferenceInternalToInternal() {
        RuleSet ruleSet = this.loadRuleSet(REF_INTERNAL_TO_INTERNAL);
        Rule rule = ruleSet.getRuleByName("MockRuleName");
        Assertions.assertNotNull((Object)rule, (String)"Could not find Rule MockRuleName");
        Rule ruleRef = ruleSet.getRuleByName("MockRuleNameRef");
        Assertions.assertNotNull((Object)ruleRef, (String)"Could not find Rule MockRuleNameRef");
    }

    @Test
    void testReferenceInternalToInternalChain() {
        RuleSet ruleSet = this.loadRuleSet(REF_INTERNAL_TO_INTERNAL_CHAIN);
        Rule rule = ruleSet.getRuleByName("MockRuleName");
        Assertions.assertNotNull((Object)rule, (String)"Could not find Rule MockRuleName");
        Rule ruleRef = ruleSet.getRuleByName("MockRuleNameRef");
        Assertions.assertNotNull((Object)ruleRef, (String)"Could not find Rule MockRuleNameRef");
        Rule ruleRefRef = ruleSet.getRuleByName("MockRuleNameRefRef");
        Assertions.assertNotNull((Object)ruleRefRef, (String)"Could not find Rule MockRuleNameRefRef");
    }

    @Test
    void testReferenceInternalToExternal() {
        RuleSet ruleSet = this.loadRuleSet(REF_INTERNAL_TO_EXTERNAL);
        Rule rule = ruleSet.getRuleByName("ExternalRefRuleName");
        Assertions.assertNotNull((Object)rule, (String)"Could not find Rule ExternalRefRuleName");
        Rule ruleRef = ruleSet.getRuleByName("ExternalRefRuleNameRef");
        Assertions.assertNotNull((Object)ruleRef, (String)"Could not find Rule ExternalRefRuleNameRef");
    }

    @Test
    void testReferenceInternalToExternalChain() {
        RuleSet ruleSet = this.loadRuleSet(REF_INTERNAL_TO_EXTERNAL_CHAIN);
        Rule rule = ruleSet.getRuleByName("ExternalRefRuleName");
        Assertions.assertNotNull((Object)rule, (String)"Could not find Rule ExternalRefRuleName");
        Rule ruleRef = ruleSet.getRuleByName("ExternalRefRuleNameRef");
        Assertions.assertNotNull((Object)ruleRef, (String)"Could not find Rule ExternalRefRuleNameRef");
        Rule ruleRefRef = ruleSet.getRuleByName("ExternalRefRuleNameRefRef");
        Assertions.assertNotNull((Object)ruleRefRef, (String)"Could not find Rule ExternalRefRuleNameRefRef");
    }

    @Test
    void testReferencePriority() {
        RuleSetLoader config = new RuleSetLoader().warnDeprecated(false);
        RuleSetLoader rulesetLoader = config.filterAbovePriority(RulePriority.LOW);
        RuleSet ruleSet = rulesetLoader.loadFromString("ruleset.xml", REF_INTERNAL_TO_INTERNAL_CHAIN);
        Assertions.assertEquals((int)3, (int)ruleSet.getRules().size(), (String)"Number of Rules");
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("MockRuleName"));
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("MockRuleNameRef"));
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("MockRuleNameRefRef"));
        rulesetLoader = config.filterAbovePriority(RulePriority.MEDIUM_HIGH);
        ruleSet = rulesetLoader.loadFromString("ruleset.xml", REF_INTERNAL_TO_INTERNAL_CHAIN);
        Assertions.assertEquals((int)2, (int)ruleSet.getRules().size(), (String)"Number of Rules");
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("MockRuleNameRef"));
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("MockRuleNameRefRef"));
        rulesetLoader = config.filterAbovePriority(RulePriority.HIGH);
        ruleSet = rulesetLoader.loadFromString("ruleset.xml", REF_INTERNAL_TO_INTERNAL_CHAIN);
        Assertions.assertEquals((int)1, (int)ruleSet.getRules().size(), (String)"Number of Rules");
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("MockRuleNameRefRef"));
        rulesetLoader = config.filterAbovePriority(RulePriority.LOW);
        ruleSet = rulesetLoader.loadFromString("ruleset.xml", REF_INTERNAL_TO_EXTERNAL_CHAIN);
        Assertions.assertEquals((int)3, (int)ruleSet.getRules().size(), (String)"Number of Rules");
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("ExternalRefRuleName"));
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("ExternalRefRuleNameRef"));
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("ExternalRefRuleNameRefRef"));
        rulesetLoader = config.filterAbovePriority(RulePriority.MEDIUM_HIGH);
        ruleSet = rulesetLoader.loadFromString("ruleset.xml", REF_INTERNAL_TO_EXTERNAL_CHAIN);
        Assertions.assertEquals((int)2, (int)ruleSet.getRules().size(), (String)"Number of Rules");
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("ExternalRefRuleNameRef"));
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("ExternalRefRuleNameRefRef"));
        rulesetLoader = config.filterAbovePriority(RulePriority.HIGH);
        ruleSet = rulesetLoader.loadFromString("ruleset.xml", REF_INTERNAL_TO_EXTERNAL_CHAIN);
        Assertions.assertEquals((int)1, (int)ruleSet.getRules().size(), (String)"Number of Rules");
        Assertions.assertNotNull((Object)ruleSet.getRuleByName("ExternalRefRuleNameRefRef"));
    }

    @Test
    void testOverridePriorityLoadWithMinimum() {
        RuleSetLoader rulesetLoader = new RuleSetLoader().filterAbovePriority(RulePriority.MEDIUM_LOW).warnDeprecated(true);
        RuleSet ruleset = rulesetLoader.loadFromResource("net/sourceforge/pmd/rulesets/ruleset-minimum-priority.xml");
        Assertions.assertEquals((int)1, (int)ruleset.getRules().size(), (String)"Number of Rules");
        Assertions.assertNull((Object)ruleset.getRuleByName("DummyBasicMockRule"));
        Assertions.assertNotNull((Object)ruleset.getRuleByName("SampleXPathRule"));
        rulesetLoader = new RuleSetLoader();
        ruleset = rulesetLoader.loadFromResource("net/sourceforge/pmd/rulesets/ruleset-minimum-priority.xml");
        Assertions.assertEquals((int)2, (int)ruleset.getRules().size(), (String)"Number of Rules");
        Rule dummyBasicMockRule = ruleset.getRuleByName("DummyBasicMockRule");
        Assertions.assertEquals((Object)RulePriority.LOW, (Object)dummyBasicMockRule.getPriority(), (String)"Wrong Priority");
    }

    @Test
    void testExcludeWithMinimumPriority() {
        RuleSetLoader rulesetLoader = new RuleSetLoader().filterAbovePriority(RulePriority.HIGH);
        RuleSet ruleset = rulesetLoader.loadFromResource("net/sourceforge/pmd/rulesets/ruleset-minimum-priority-exclusion.xml");
        Assertions.assertEquals((int)0, (int)ruleset.getRules().size(), (String)"Number of Rules");
        rulesetLoader = new RuleSetLoader().filterAbovePriority(RulePriority.LOW);
        ruleset = rulesetLoader.loadFromResource("net/sourceforge/pmd/rulesets/ruleset-minimum-priority-exclusion.xml");
        Assertions.assertEquals((int)1, (int)ruleset.getRules().size(), (String)"Number of Rules");
        Assertions.assertNull((Object)ruleset.getRuleByName("DummyBasicMockRule"));
        Assertions.assertNotNull((Object)ruleset.getRuleByName("SampleXPathRule"));
    }

    @Test
    void testOverrideMessage() {
        Rule r = this.loadFirstRule(REF_OVERRIDE_ORIGINAL_NAME);
        Assertions.assertEquals((Object)"TestMessageOverride", (Object)r.getMessage());
    }

    @Test
    void testOverrideMessageOneElem() {
        Rule r = this.loadFirstRule(REF_OVERRIDE_ORIGINAL_NAME_ONE_ELEM);
        Assertions.assertEquals((Object)"TestMessageOverride", (Object)r.getMessage());
    }

    @Test
    void testIncorrectExternalRef() {
        this.assertCannotParse(REF_MISSPELLED_XREF);
    }

    @Test
    void testSetPriority() {
        RuleSetLoader rulesetLoader = new RuleSetLoader().filterAbovePriority(RulePriority.MEDIUM_HIGH).warnDeprecated(false);
        Assertions.assertEquals((int)0, (int)rulesetLoader.loadFromString("ruleset.xml", SINGLE_RULE).size());
        rulesetLoader = new RuleSetLoader().filterAbovePriority(RulePriority.MEDIUM_LOW).warnDeprecated(false);
        Assertions.assertEquals((int)1, (int)rulesetLoader.loadFromString("ruleset.xml", SINGLE_RULE).size());
    }

    @Test
    void testLanguage() {
        Rule r = this.loadFirstRule(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.LANGUAGE, "dummy"), new String[0])));
        Assertions.assertEquals((Object)((Object)PmdCoreTestUtils.dummyLanguage()), (Object)r.getLanguage());
    }

    @Test
    void testIncorrectLanguage() {
        this.assertCannotParse(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.LANGUAGE, "bogus"), new String[0])));
    }

    @Test
    void testIncorrectPriority() {
        this.assertCannotParse(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule(RuleSetFactoryTest.priority("not a priority"))));
        this.verifyFoundAnErrorWithMessage(RuleSetFactoryTest.containing("Not a valid priority: 'not a priority'"));
    }

    @Test
    void testMinimumLanguageVersion() {
        Rule r = this.loadFirstRule(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.MINIMUM_LANGUAGE_VERSION, "1.4"), new String[0])));
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.4"), (Object)r.getMinimumLanguageVersion());
    }

    @Test
    void testIncorrectMinimumLanguageVersion() {
        this.assertCannotParse(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.MINIMUM_LANGUAGE_VERSION, "bogus"), new String[0])));
        this.verifyFoundAnErrorWithMessage(RuleSetFactoryTest.containing("valid language version").and(RuleSetFactoryTest.containing("'1.0', '1.1', '1.2'")));
    }

    @Test
    void testIncorrectMinimumLanguageVersionWithLanguageSetInJava() {
        this.assertCannotParse("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset name=\"TODO\">\n    <description>TODO</description>\n\n    <rule name=\"TODO\"\n          message=\"TODO\"\n          class=\"net.sourceforge.pmd.util.FooRuleWithLanguageSetInJava\"\n          minimumLanguageVersion=\"12\">\n        <description>TODO</description>\n        <priority>2</priority>\n    </rule>\n\n</ruleset>");
        this.verifyFoundAnErrorWithMessage(RuleSetFactoryTest.containing("valid language version"));
    }

    @Test
    void testMaximumLanguageVersion() {
        Rule r = this.loadFirstRule(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.MAXIMUM_LANGUAGE_VERSION, "1.7"), new String[0])));
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.7"), (Object)r.getMaximumLanguageVersion());
    }

    @Test
    void testIncorrectMaximumLanguageVersion() {
        this.assertCannotParse(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.MAXIMUM_LANGUAGE_VERSION, "bogus"), new String[0])));
        this.verifyFoundAnErrorWithMessage(RuleSetFactoryTest.containing("valid language version").and(RuleSetFactoryTest.containing("'1.0', '1.1', '1.2'")));
    }

    @Test
    void testInvertedMinimumMaximumLanguageVersions() {
        this.assertCannotParse(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> {
            attrs.put(SchemaConstants.MINIMUM_LANGUAGE_VERSION, "1.7");
            attrs.put(SchemaConstants.MAXIMUM_LANGUAGE_VERSION, "1.4");
        }, new String[0])));
        this.verifyFoundAnErrorWithMessage(RuleSetFactoryTest.containing("version range"));
    }

    @Test
    void testDirectDeprecatedRule() {
        Rule r = this.loadFirstRule(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.DEPRECATED, "true"), new String[0])));
        Assertions.assertNotNull((Object)r, (String)"Direct Deprecated Rule");
        Assertions.assertTrue((boolean)r.isDeprecated());
    }

    @Test
    void testReferenceToDeprecatedRule() {
        Rule r = this.loadFirstRule(REFERENCE_TO_DEPRECATED_RULE);
        Assertions.assertNotNull((Object)r, (String)"Reference to Deprecated Rule");
        Assertions.assertTrue((boolean)(r instanceof RuleReference), (String)"Rule Reference");
        Assertions.assertFalse((boolean)r.isDeprecated(), (String)"Not deprecated");
        Assertions.assertTrue((boolean)((RuleReference)r).getRule().isDeprecated(), (String)"Original Rule Deprecated");
        Assertions.assertEquals((Object)r.getName(), (Object)DEPRECATED_RULE_NAME, (String)"Rule name");
    }

    @Test
    void testRuleSetReferenceWithDeprecatedRule() {
        RuleSet ruleSet = this.loadRuleSet(REFERENCE_TO_RULESET_WITH_DEPRECATED_RULE);
        Assertions.assertNotNull((Object)ruleSet, (String)"RuleSet");
        Assertions.assertFalse((boolean)ruleSet.getRules().isEmpty(), (String)"RuleSet empty");
        Rule r = ruleSet.getRuleByName(DEPRECATED_RULE_NAME);
        Assertions.assertNull((Object)r, (String)"Deprecated Rule Reference");
        for (Rule rule : ruleSet.getRules()) {
            Assertions.assertFalse((boolean)rule.isDeprecated(), (String)"Rule not deprecated");
        }
    }

    @Test
    void testDeprecatedRuleSetReference() {
        RuleSet ruleSet = new RuleSetLoader().loadFromResource("net/sourceforge/pmd/rulesets/ruleset-deprecated.xml");
        Assertions.assertEquals((int)2, (int)ruleSet.getRules().size());
    }

    @Test
    void testExternalReferences() {
        RuleSet rs = this.loadRuleSet(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.ruleRef("net/sourceforge/pmd/lang/rule/external-reference-ruleset.xml/MockRule")));
        Assertions.assertEquals((int)1, (int)rs.size());
        Assertions.assertEquals((Object)MockRule.class.getName(), (Object)rs.getRuleByName("MockRule").getRuleClass());
    }

    @Test
    void testIncludeExcludePatterns() {
        RuleSet ruleSet = this.loadRuleSet(INCLUDE_EXCLUDE_RULESET);
        Assertions.assertNotNull((Object)ruleSet.getFileInclusions(), (String)"Include patterns");
        Assertions.assertEquals((int)2, (int)ruleSet.getFileInclusions().size(), (String)"Include patterns size");
        Assertions.assertEquals((Object)"include1", (Object)((Pattern)ruleSet.getFileInclusions().get(0)).pattern(), (String)"Include pattern #1");
        Assertions.assertEquals((Object)"include2", (Object)((Pattern)ruleSet.getFileInclusions().get(1)).pattern(), (String)"Include pattern #2");
        Assertions.assertNotNull((Object)ruleSet.getFileExclusions(), (String)"Exclude patterns");
        Assertions.assertEquals((int)3, (int)ruleSet.getFileExclusions().size(), (String)"Exclude patterns size");
        Assertions.assertEquals((Object)"exclude1", (Object)((Pattern)ruleSet.getFileExclusions().get(0)).pattern(), (String)"Exclude pattern #1");
        Assertions.assertEquals((Object)"exclude2", (Object)((Pattern)ruleSet.getFileExclusions().get(1)).pattern(), (String)"Exclude pattern #2");
        Assertions.assertEquals((Object)"exclude3", (Object)((Pattern)ruleSet.getFileExclusions().get(2)).pattern(), (String)"Exclude pattern #3");
    }

    @Test
    void testBug1202() {
        this.assertCannotParse(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.ruleRef("net.sourceforge.pmd.rules.XPathRule", RuleSetFactoryTest.priority("1"), RuleSetFactoryTest.properties(RuleSetFactoryTest.propertyWithValueAttr("xpath", "//TypeDeclaration"), RuleSetFactoryTest.propertyWithValueAttr("message", "Foo")))));
    }

    @Test
    void testEmptyRuleSetFile() {
        RuleSet ruleset = this.loadRuleSet(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.excludePattern(".*Test.*")));
        Assertions.assertEquals((int)0, (int)ruleset.getRules().size());
    }

    @Test
    void testEmptyRuleSetReferencedShouldNotBeDeprecated() {
        RuleSet ruleset = this.loadRuleSet(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.ruleRef("rulesets/dummy/empty-ruleset.xml")));
        Assertions.assertEquals((int)0, (int)ruleset.getRules().size());
        this.verifyNoWarnings();
    }

    @Test
    void testWrongRuleNameReferenced() {
        this.assertCannotParse(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.ruleRef("net/sourceforge/pmd/lang/rule/TestRuleset1.xml/ThisRuleDoesNotExist")));
    }

    @Test
    void testRuleReferenceWithNameOverridden() {
        RuleSet rs = this.loadRuleSet("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<ruleset xmlns=\"http://pmd.sourceforge.net/ruleset/2.0.0\"\n         xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         name=\"pmd-eclipse\"\n         xsi:schemaLocation=\"http://pmd.sourceforge.net/ruleset/2.0.0 https://pmd.sourceforge.io/ruleset_2_0_0.xsd\">\n   <description>PMD Plugin preferences rule set</description>\n<rule name=\"OverriddenDummyBasicMockRule\"\n    ref=\"rulesets/dummy/basic.xml/DummyBasicMockRule\">\n</rule>\n\n</ruleset>");
        Rule r = (Rule)rs.getRules().iterator().next();
        Assertions.assertEquals((Object)"OverriddenDummyBasicMockRule", (Object)r.getName());
        RuleReference ruleRef = (RuleReference)r;
        Assertions.assertEquals((Object)"DummyBasicMockRule", (Object)ruleRef.getRule().getName());
    }

    @Test
    void testWrongRuleNameExcluded() {
        RuleSet ruleset = this.loadRuleSet("<?xml version=\"1.0\"?>\n<ruleset name=\"Custom ruleset for tests\"\n    xmlns=\"http://pmd.sourceforge.net/ruleset/2.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://pmd.sourceforge.net/ruleset/2.0.0 https://pmd.sourceforge.io/ruleset_2_0_0.xsd\">\n  <description>Custom ruleset for tests</description>\n  <rule ref=\"net/sourceforge/pmd/lang/rule/TestRuleset1.xml\">\n    <exclude name=\"ThisRuleDoesNotExist\"/>\n  </rule>\n</ruleset>\n");
        Assertions.assertEquals((int)4, (int)ruleset.getRules().size());
    }

    @Test
    void testExcludeAndImportTwice() {
        RuleSet ruleset = this.loadRuleSet(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rulesetRef("rulesets/dummy/basic.xml", RuleSetFactoryTest.excludeRule("DummyBasicMockRule"))));
        Assertions.assertNull((Object)ruleset.getRuleByName("DummyBasicMockRule"));
        RuleSet ruleset2 = this.loadRuleSet(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rulesetRef("rulesets/dummy/basic.xml", RuleSetFactoryTest.excludeRule("DummyBasicMockRule")), RuleSetFactoryTest.rulesetRef("rulesets/dummy/basic.xml", new String[0])));
        Assertions.assertNotNull((Object)ruleset2.getRuleByName("DummyBasicMockRule"));
        RuleSet ruleset3 = this.loadRuleSet(RuleSetFactoryTest.rulesetXml(RuleSetFactoryTest.rulesetRef("rulesets/dummy/basic.xml", new String[0]), RuleSetFactoryTest.rulesetRef("rulesets/dummy/basic.xml", RuleSetFactoryTest.excludeRule("DummyBasicMockRule"))));
        Assertions.assertNotNull((Object)ruleset3.getRuleByName("DummyBasicMockRule"));
    }

    @Test
    void testMissingRuleSetNameIsWarning() throws Exception {
        SystemLambda.tapSystemErr(() -> this.loadRuleSetWithDeprecationWarnings("<?xml version=\"1.0\"?>\n<ruleset \n    xmlns=\"http://pmd.sourceforge.net/ruleset/2.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://pmd.sourceforge.net/ruleset/2.0.0 https://pmd.sourceforge.io/ruleset_2_0_0.xsd\">\n  <description>Custom ruleset for tests</description>\n  <rule ref=\"rulesets/dummy/basic.xml\"/>\n  </ruleset>\n"));
        this.verifyFoundAWarningWithMessage(RuleSetFactoryTest.containing("RuleSet name is missing."));
    }

    @Test
    void testMissingRuleSetDescriptionIsWarning() {
        this.loadRuleSetWithDeprecationWarnings("<?xml version=\"1.0\"?>\n<ruleset name=\"then name\"\n    xmlns=\"http://pmd.sourceforge.net/ruleset/2.0.0\"\n    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n    xsi:schemaLocation=\"http://pmd.sourceforge.net/ruleset/2.0.0 https://pmd.sourceforge.io/ruleset_2_0_0.xsd\">\n  <rule ref=\"rulesets/dummy/basic.xml\"/>\n  </ruleset>\n");
        this.verifyFoundAWarningWithMessage(RuleSetFactoryTest.containing("RuleSet description is missing."));
    }
}

