/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import java.util.Map;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulesetFactoryTestBase;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.internal.xml.SchemaConstant;
import net.sourceforge.pmd.util.internal.xml.SchemaConstants;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RuleSetFactoryMessagesTest
extends RulesetFactoryTestBase {
    RuleSetFactoryMessagesTest() {
    }

    @Test
    void testFullMessage() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> this.assertCannotParse(RuleSetFactoryMessagesTest.rulesetXml(RuleSetFactoryMessagesTest.dummyRule(RuleSetFactoryMessagesTest.priority("not a priority")))));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"Error at dummyRuleset.xml:9:1\n 7| \n 8| <rule name=\"MockRuleName\" language=\"dummy\" class=\"net.sourceforge.pmd.lang.rule.MockRuleWithNoProperties\" message=\"avoid the mock rule\">\n 9| <priority>not a priority</priority></rule></ruleset>\n    ^^^^^^^^^ Not a valid priority: 'not a priority', expected a number in [1,5]"));
    }

    @Test
    void testPropertyConstraintFailure() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> this.assertCannotParse(RuleSetFactoryMessagesTest.rulesetXml(RuleSetFactoryMessagesTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.CLASS, MockRule.class.getName()), RuleSetFactoryMessagesTest.properties(RuleSetFactoryMessagesTest.propertyWithValueAttr(MockRule.PROP.name(), "-4"))))));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 10| <property name='testIntProperty' value='-4'/>\n                                      ^^^^^ Value should be between 1 and 100"));
    }

    @Test
    void testPropertyValueAsAttributeAndTag() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> Assertions.assertEquals((int)1, (Integer)((Integer)this.loadFirstRule(RuleSetFactoryMessagesTest.rulesetXml(RuleSetFactoryMessagesTest.dummyRule((Map<SchemaConstant, String> attrs) -> attrs.put(SchemaConstants.CLASS, MockRule.class.getName()), RuleSetFactoryMessagesTest.properties("<property name='" + MockRule.PROP.name() + "' value='4'>\n  <value>1</value>\n</property>\n")))).getProperty(MockRule.PROP))));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 10| <property name='testIntProperty' value='4'>\n                                      ^^^^^ Both a 'value' attribute and a child element are present, the attribute will be ignored\n"));
    }

    @Test
    void testStringMultiPropertyDelimiterDeprecated() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> {
            Rule r = this.loadFirstRule(RuleSetFactoryMessagesTest.rulesetXml(RuleSetFactoryMessagesTest.dummyRule(RuleSetFactoryMessagesTest.priority("3"), RuleSetFactoryMessagesTest.properties("<property name=\"packageRegEx\" value=\"com.aptsssss|com.abc\" delimiter=\"|\" type=\"List[String]\" description=\"valid packages\"/>"))));
            Object propValue = r.getProperty(r.getPropertyDescriptor("packageRegEx"));
            Assertions.assertEquals((Object)CollectionUtil.listOf((Object)"com.aptsssss|com.abc", (Object[])new String[0]), (Object)propValue);
            this.verifyFoundAWarningWithMessage(RuleSetFactoryMessagesTest.containing("Delimiter attribute is not supported anymore, values are always comma-separated."));
        });
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 11| <property name=\"packageRegEx\" value=\"com.aptsssss|com.abc\" delimiter=\"|\" type=\"List[String]\" description=\"valid packages\"/></properties></rule></ruleset>\n                                                                ^^^^^^^^^ Delimiter attribute is not supported anymore, values are always comma-separated.\n"));
    }
}

