/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import com.github.stefanbirkner.systemlambda.SystemLambda;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RulesetFactoryTestBase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RuleSetFactoryDuplicatedRuleLoggingTest
extends RulesetFactoryTestBase {
    private static final String DIR = "net/sourceforge/pmd/rulesets/duplicatedRuleLoggingTest";

    RuleSetFactoryDuplicatedRuleLoggingTest() {
    }

    @Test
    void duplicatedRuleReferenceShouldWarn() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> {
            RuleSet ruleset = this.loadRuleSetInDir(DIR, "duplicatedRuleReference.xml");
            Assertions.assertEquals((int)1, (int)ruleset.getRules().size());
            Rule mockRule = ruleset.getRuleByName("DummyBasicMockRule");
            Assertions.assertNotNull((Object)mockRule);
            Assertions.assertEquals((Object)RulePriority.MEDIUM, (Object)mockRule.getPriority());
        });
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"The rule DummyBasicMockRule is referenced multiple times in ruleset 'Custom Rules'. Only the last rule configuration is used"));
    }

    @Test
    void duplicatedRuleReferenceWithOverrideShouldNotWarn() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> {
            RuleSet ruleset = this.loadRuleSetInDir(DIR, "duplicatedRuleReferenceWithOverride.xml");
            Assertions.assertEquals((int)2, (int)ruleset.getRules().size());
            Rule mockRule = ruleset.getRuleByName("DummyBasicMockRule");
            Assertions.assertNotNull((Object)mockRule);
            Assertions.assertEquals((Object)RulePriority.HIGH, (Object)mockRule.getPriority());
            Assertions.assertNotNull((Object)ruleset.getRuleByName("SampleXPathRule"));
        });
        Assertions.assertTrue((boolean)log.isEmpty());
    }

    @Test
    void duplicatedRuleReferenceWithOverrideBeforeShouldNotWarn() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> {
            RuleSet ruleset = this.loadRuleSetInDir(DIR, "duplicatedRuleReferenceWithOverrideBefore.xml");
            Assertions.assertEquals((int)2, (int)ruleset.getRules().size());
            Rule mockRule = ruleset.getRuleByName("DummyBasicMockRule");
            Assertions.assertNotNull((Object)mockRule);
            Assertions.assertEquals((Object)RulePriority.HIGH, (Object)mockRule.getPriority());
            Assertions.assertNotNull((Object)ruleset.getRuleByName("SampleXPathRule"));
        });
        Assertions.assertTrue((boolean)log.isEmpty());
    }

    @Test
    void multipleDuplicates() throws Exception {
        String log = SystemLambda.tapSystemErr(() -> {
            RuleSet ruleset = this.loadRuleSetInDir(DIR, "multipleDuplicates.xml");
            Assertions.assertEquals((int)2, (int)ruleset.getRules().size());
            Rule mockRule = ruleset.getRuleByName("DummyBasicMockRule");
            Assertions.assertNotNull((Object)mockRule);
            Assertions.assertEquals((Object)RulePriority.MEDIUM_HIGH, (Object)mockRule.getPriority());
            Assertions.assertNotNull((Object)ruleset.getRuleByName("SampleXPathRule"));
        });
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"The rule DummyBasicMockRule is referenced multiple times in ruleset 'Custom Rules'. Only the last rule configuration is used."));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"The ruleset rulesets/dummy/basic.xml is referenced multiple times in ruleset 'Custom Rules'"));
    }
}

