/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import net.sourceforge.pmd.PmdCoreTestUtils;
import net.sourceforge.pmd.lang.Dummy2LanguageModule;
import net.sourceforge.pmd.lang.DummyLanguageModule;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.rule.MockRule;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleReference;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReference;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RuleReferenceTest {
    RuleReferenceTest() {
    }

    @Test
    void testRuleSetReference() {
        RuleSetReference ruleSetReference = new RuleSetReference("somename");
        RuleReference ruleReference = new RuleReference(null, ruleSetReference);
        Assertions.assertEquals((Object)ruleSetReference, (Object)ruleReference.getRuleSetReference(), (String)"Not same rule set reference");
    }

    @Test
    void testOverride() {
        PropertyDescriptor PROPERTY1_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"property1").desc("Test property")).defaultValue((Object)"")).build();
        MockRule rule = new MockRule();
        rule.definePropertyDescriptor(PROPERTY1_DESCRIPTOR);
        DummyLanguageModule dummyLang = PmdCoreTestUtils.dummyLanguage();
        rule.setLanguage((Language)dummyLang);
        rule.setName("name1");
        rule.setProperty(PROPERTY1_DESCRIPTOR, "value1");
        rule.setMessage("message1");
        rule.setDescription("description1");
        rule.addExample("example1");
        rule.setExternalInfoUrl("externalInfoUrl1");
        rule.setPriority(RulePriority.HIGH);
        PropertyDescriptor PROPERTY2_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"property2").desc("Test property")).defaultValue((Object)"")).build();
        RuleReference ruleReference = new RuleReference((Rule)rule, null);
        ruleReference.definePropertyDescriptor(PROPERTY2_DESCRIPTOR);
        ruleReference.setMinimumLanguageVersion(dummyLang.getVersion("1.3"));
        ruleReference.setMaximumLanguageVersion(dummyLang.getVersion("1.7"));
        ruleReference.setDeprecated(true);
        ruleReference.setName("name2");
        ruleReference.setProperty(PROPERTY1_DESCRIPTOR, (Object)"value2");
        ruleReference.setProperty(PROPERTY2_DESCRIPTOR, (Object)"value3");
        ruleReference.setMessage("message2");
        ruleReference.setDescription("description2");
        ruleReference.addExample("example2");
        ruleReference.setExternalInfoUrl("externalInfoUrl2");
        ruleReference.setPriority(RulePriority.MEDIUM_HIGH);
        this.validateOverriddenValues((PropertyDescriptor<String>)PROPERTY1_DESCRIPTOR, (PropertyDescriptor<String>)PROPERTY2_DESCRIPTOR, ruleReference);
    }

    @Test
    void testLanguageOverrideDisallowed() {
        MockRule rule = new MockRule();
        DummyLanguageModule dummyLang = PmdCoreTestUtils.dummyLanguage();
        rule.setLanguage((Language)dummyLang);
        RuleReference ruleReference = new RuleReference((Rule)rule, null);
        Assertions.assertThrows(UnsupportedOperationException.class, () -> ruleReference.setLanguage((Language)Dummy2LanguageModule.getInstance()));
        Assertions.assertEquals((Object)((Object)dummyLang), (Object)ruleReference.getLanguage());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ruleReference.setMaximumLanguageVersion(Dummy2LanguageModule.getInstance().getVersion("1.0")));
        Assertions.assertEquals((Object)rule.getMaximumLanguageVersion(), (Object)ruleReference.getOverriddenMaximumLanguageVersion());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ruleReference.setMinimumLanguageVersion(Dummy2LanguageModule.getInstance().getVersion("1.0")));
        Assertions.assertEquals((Object)rule.getMinimumLanguageVersion(), (Object)ruleReference.getMinimumLanguageVersion());
    }

    @Test
    void testDeepCopyOverride() {
        PropertyDescriptor PROPERTY1_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"property1").desc("Test property")).defaultValue((Object)"")).build();
        MockRule rule = new MockRule();
        rule.definePropertyDescriptor(PROPERTY1_DESCRIPTOR);
        DummyLanguageModule dummyLang = PmdCoreTestUtils.dummyLanguage();
        rule.setLanguage((Language)dummyLang);
        rule.setName("name1");
        rule.setProperty(PROPERTY1_DESCRIPTOR, "value1");
        rule.setMessage("message1");
        rule.setDescription("description1");
        rule.addExample("example1");
        rule.setExternalInfoUrl("externalInfoUrl1");
        rule.setPriority(RulePriority.HIGH);
        PropertyDescriptor PROPERTY2_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"property2").desc("Test property")).defaultValue((Object)"")).build();
        RuleReference ruleReference = new RuleReference((Rule)rule, null);
        ruleReference.definePropertyDescriptor(PROPERTY2_DESCRIPTOR);
        ruleReference.setLanguage((Language)dummyLang);
        ruleReference.setMinimumLanguageVersion(dummyLang.getVersion("1.3"));
        ruleReference.setMaximumLanguageVersion(dummyLang.getVersion("1.7"));
        ruleReference.setDeprecated(true);
        ruleReference.setName("name2");
        ruleReference.setProperty(PROPERTY1_DESCRIPTOR, (Object)"value2");
        ruleReference.setProperty(PROPERTY2_DESCRIPTOR, (Object)"value3");
        ruleReference.setMessage("message2");
        ruleReference.setDescription("description2");
        ruleReference.addExample("example2");
        ruleReference.setExternalInfoUrl("externalInfoUrl2");
        ruleReference.setPriority(RulePriority.MEDIUM_HIGH);
        this.validateOverriddenValues((PropertyDescriptor<String>)PROPERTY1_DESCRIPTOR, (PropertyDescriptor<String>)PROPERTY2_DESCRIPTOR, (RuleReference)ruleReference.deepCopy());
    }

    private void validateOverriddenValues(PropertyDescriptor<String> propertyDescriptor1, PropertyDescriptor<String> propertyDescriptor2, RuleReference ruleReference) {
        Assertions.assertEquals((Object)((Object)PmdCoreTestUtils.dummyLanguage()), (Object)ruleReference.getLanguage(), (String)"Override failed");
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.3"), (Object)ruleReference.getMinimumLanguageVersion(), (String)"Override failed");
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.3"), (Object)ruleReference.getOverriddenMinimumLanguageVersion(), (String)"Override failed");
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.7"), (Object)ruleReference.getMaximumLanguageVersion(), (String)"Override failed");
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.7"), (Object)ruleReference.getOverriddenMaximumLanguageVersion(), (String)"Override failed");
        Assertions.assertEquals((Object)false, (Object)ruleReference.getRule().isDeprecated(), (String)"Override failed");
        Assertions.assertEquals((Object)true, (Object)ruleReference.isDeprecated(), (String)"Override failed");
        Assertions.assertEquals((Object)true, (Object)ruleReference.isOverriddenDeprecated(), (String)"Override failed");
        Assertions.assertEquals((Object)"name2", (Object)ruleReference.getName(), (String)"Override failed");
        Assertions.assertEquals((Object)"name2", (Object)ruleReference.getOverriddenName(), (String)"Override failed");
        Assertions.assertEquals((Object)"value2", (Object)ruleReference.getProperty(propertyDescriptor1), (String)"Override failed");
        Assertions.assertEquals((Object)"value3", (Object)ruleReference.getProperty(propertyDescriptor2), (String)"Override failed");
        Assertions.assertTrue((boolean)ruleReference.getPropertyDescriptors().contains(propertyDescriptor1), (String)"Override failed");
        Assertions.assertTrue((boolean)ruleReference.getPropertyDescriptors().contains(propertyDescriptor2), (String)"Override failed");
        Assertions.assertFalse((boolean)ruleReference.getOverriddenPropertyDescriptors().contains(propertyDescriptor1), (String)"Override failed");
        Assertions.assertTrue((boolean)ruleReference.getOverriddenPropertyDescriptors().contains(propertyDescriptor2), (String)"Override failed");
        Assertions.assertTrue((boolean)ruleReference.getPropertiesByPropertyDescriptor().containsKey(propertyDescriptor1), (String)"Override failed");
        Assertions.assertTrue((boolean)ruleReference.getPropertiesByPropertyDescriptor().containsKey(propertyDescriptor2), (String)"Override failed");
        Assertions.assertTrue((boolean)ruleReference.getOverriddenPropertiesByPropertyDescriptor().containsKey(propertyDescriptor1), (String)"Override failed");
        Assertions.assertTrue((boolean)ruleReference.getOverriddenPropertiesByPropertyDescriptor().containsKey(propertyDescriptor2), (String)"Override failed");
        Assertions.assertEquals((Object)"message2", (Object)ruleReference.getMessage(), (String)"Override failed");
        Assertions.assertEquals((Object)"message2", (Object)ruleReference.getOverriddenMessage(), (String)"Override failed");
        Assertions.assertEquals((Object)"description2", (Object)ruleReference.getDescription(), (String)"Override failed");
        Assertions.assertEquals((Object)"description2", (Object)ruleReference.getOverriddenDescription(), (String)"Override failed");
        Assertions.assertEquals((int)2, (int)ruleReference.getExamples().size(), (String)"Override failed");
        Assertions.assertEquals((Object)"example1", ruleReference.getExamples().get(0), (String)"Override failed");
        Assertions.assertEquals((Object)"example2", ruleReference.getExamples().get(1), (String)"Override failed");
        Assertions.assertEquals((Object)"example2", ruleReference.getOverriddenExamples().get(0), (String)"Override failed");
        Assertions.assertEquals((Object)"externalInfoUrl2", (Object)ruleReference.getExternalInfoUrl(), (String)"Override failed");
        Assertions.assertEquals((Object)"externalInfoUrl2", (Object)ruleReference.getOverriddenExternalInfoUrl(), (String)"Override failed");
        Assertions.assertEquals((Object)RulePriority.MEDIUM_HIGH, (Object)ruleReference.getPriority(), (String)"Override failed");
        Assertions.assertEquals((Object)RulePriority.MEDIUM_HIGH, (Object)ruleReference.getOverriddenPriority(), (String)"Override failed");
    }

    @Test
    void testNotOverride() {
        PropertyDescriptor PROPERTY1_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty((String)"property1").desc("Test property")).defaultValue((Object)"")).build();
        MockRule rule = new MockRule();
        rule.definePropertyDescriptor(PROPERTY1_DESCRIPTOR);
        rule.setLanguage((Language)PmdCoreTestUtils.dummyLanguage());
        rule.setMinimumLanguageVersion(PmdCoreTestUtils.dummyLanguage().getVersion("1.3"));
        rule.setMaximumLanguageVersion(PmdCoreTestUtils.dummyLanguage().getVersion("1.7"));
        rule.setName("name1");
        rule.setProperty(PROPERTY1_DESCRIPTOR, "value1");
        rule.setMessage("message1");
        rule.setDescription("description1");
        rule.addExample("example1");
        rule.setExternalInfoUrl("externalInfoUrl1");
        rule.setPriority(RulePriority.HIGH);
        RuleReference ruleReference = new RuleReference((Rule)rule, null);
        ruleReference.setMinimumLanguageVersion(PmdCoreTestUtils.dummyLanguage().getVersion("1.3"));
        ruleReference.setMaximumLanguageVersion(PmdCoreTestUtils.dummyLanguage().getVersion("1.7"));
        ruleReference.setDeprecated(false);
        ruleReference.setName("name1");
        ruleReference.setProperty(PROPERTY1_DESCRIPTOR, (Object)"value1");
        ruleReference.setMessage("message1");
        ruleReference.setDescription("description1");
        ruleReference.addExample("example1");
        ruleReference.setExternalInfoUrl("externalInfoUrl1");
        ruleReference.setPriority(RulePriority.HIGH);
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.3"), (Object)ruleReference.getMinimumLanguageVersion(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenMinimumLanguageVersion(), (String)"Override failed");
        Assertions.assertEquals((Object)PmdCoreTestUtils.dummyLanguage().getVersion("1.7"), (Object)ruleReference.getMaximumLanguageVersion(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenMaximumLanguageVersion(), (String)"Override failed");
        Assertions.assertEquals((Object)false, (Object)ruleReference.isDeprecated(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.isOverriddenDeprecated(), (String)"Override failed");
        Assertions.assertEquals((Object)"name1", (Object)ruleReference.getName(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenName(), (String)"Override failed");
        Assertions.assertEquals((Object)"value1", (Object)ruleReference.getProperty(PROPERTY1_DESCRIPTOR), (String)"Override failed");
        Assertions.assertEquals((Object)"message1", (Object)ruleReference.getMessage(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenMessage(), (String)"Override failed");
        Assertions.assertEquals((Object)"description1", (Object)ruleReference.getDescription(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenDescription(), (String)"Override failed");
        Assertions.assertEquals((int)1, (int)ruleReference.getExamples().size(), (String)"Override failed");
        Assertions.assertEquals((Object)"example1", ruleReference.getExamples().get(0), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenExamples(), (String)"Override failed");
        Assertions.assertEquals((Object)"externalInfoUrl1", (Object)ruleReference.getExternalInfoUrl(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenExternalInfoUrl(), (String)"Override failed");
        Assertions.assertEquals((Object)RulePriority.HIGH, (Object)ruleReference.getPriority(), (String)"Override failed");
        Assertions.assertNull((Object)ruleReference.getOverriddenPriority(), (String)"Override failed");
    }
}

