/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.metrics;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.ParameterizedMetricKey;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ParameterizedMetricKeyTest {
    private static final MetricOptions DUMMY_VERSION_1 = MetricOptions.ofOptions((MetricOption)Options.DUMMY1, (MetricOption[])new MetricOption[]{Options.DUMMY2});
    private static final MetricOptions DUMMY_VERSION_2 = MetricOptions.ofOptions((MetricOption)Options.DUMMY2, (MetricOption[])new MetricOption[0]);
    private static final Metric<Node, Double> DUMMY_METRIC = Metric.of((n, opts) -> 0.0, t -> t, (String)"dummy", (String[])new String[0]);

    ParameterizedMetricKeyTest() {
    }

    @Test
    void testIdentity() {
        ParameterizedMetricKey key1 = ParameterizedMetricKey.getInstance(DUMMY_METRIC, (MetricOptions)DUMMY_VERSION_1);
        ParameterizedMetricKey key2 = ParameterizedMetricKey.getInstance(DUMMY_METRIC, (MetricOptions)DUMMY_VERSION_1);
        Assertions.assertEquals((Object)key1, (Object)key2);
        Assertions.assertSame((Object)key1, (Object)key2);
    }

    @Test
    void testVersioning() {
        ParameterizedMetricKey key1 = ParameterizedMetricKey.getInstance(DUMMY_METRIC, (MetricOptions)DUMMY_VERSION_1);
        ParameterizedMetricKey key2 = ParameterizedMetricKey.getInstance(DUMMY_METRIC, (MetricOptions)DUMMY_VERSION_2);
        Assertions.assertNotEquals((Object)key1, (Object)key2);
        Assertions.assertNotSame((Object)key1, (Object)key2);
    }

    @Test
    void testToString() {
        ParameterizedMetricKey key1 = ParameterizedMetricKey.getInstance(DUMMY_METRIC, (MetricOptions)DUMMY_VERSION_1);
        Assertions.assertTrue((boolean)key1.toString().contains(key1.metric.displayName()));
        Assertions.assertTrue((boolean)key1.toString().contains(key1.options.toString()));
    }

    @Test
    void testAdHocMetricKey() {
        ParameterizedMetricKey key1 = ParameterizedMetricKey.getInstance(DUMMY_METRIC, (MetricOptions)DUMMY_VERSION_1);
        ParameterizedMetricKey key2 = ParameterizedMetricKey.getInstance(DUMMY_METRIC, (MetricOptions)DUMMY_VERSION_1);
        Assertions.assertNotNull((Object)key1);
        Assertions.assertNotNull((Object)key2);
        Assertions.assertSame((Object)key1, (Object)key2);
        Assertions.assertEquals((Object)key1, (Object)key2);
        Assertions.assertTrue((boolean)key1.toString().contains(key1.metric.displayName()));
        Assertions.assertTrue((boolean)key1.toString().contains(key1.options.toString()));
    }

    private static enum Options implements MetricOption
    {
        DUMMY1,
        DUMMY2;


        public String valueName() {
            return null;
        }
    }
}

